function [NTrial,NTrialSubj,NTrialChan,NTrialMat] = GetNTrials(FileMat)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	GetNTrials.m
%
%	Markus Junghoefer	[1999]
%
%
%	Function definition
%	
%
%
%
%
%=================================================================
if nargin<1; FileMat=[]; end
[DefFilePath] = SetDefPath(1,'*at*')
[NFiles,FileMat,VersionString,BatchFilePath]=ReadFileNames(FileMat,DefFilePath,'Choose file(s):');
[DefFile,DefPath]=SepFilePath(BatchFilePath);
SetDefPath(2,DefPath);
for FileInd=1:NFiles
	[File,Path,FilePath]=GetFileNameOfMat(FileMat,FileInd);
	[AvgMat,File,Path,FilePath,NTrialAvgVec,StdChanTimeMat,SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec]=ReadAvgFile(FilePath);
	if FileInd==1
		NTrialMat=zeros(NFiles,length(NTrialAvgVec));
	end
	NTrialMat(FileInd,:)=NTrialAvgVec';
end
NTrialChan=mean(NTrialMat,1);
NTrialSubj=mean(NTrialMat,2);
NTrial=mean(mean(NTrialMat));
