function[OutFilePath]=MergeAEMFiles(InFileMat,OutFilePath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	MergeMatFiles.m
%
%	Markus Junghoefer	[1996]
%
%
%	Function definition
%
%
%
%==================================================================
if nargin<2; OutFilePath=[]; end;
if nargin<1; InFileMat=[]; end;

%==================================================================

[NFiles,InFileMat]=ReadFileNames(InFileMat,'*.AEM.*','Choose AEM files:');
if NFiles<1; return; end

if isempty(OutFilePath)
	[OutFile,OutPath,OutFilePath]=WriteFilePath;
end
if NFiles<2; return; end

[NoUse,NoUse,InFilePath]=GetFileNameOfMat(InFileMat,1);
[AbsMatTmp1,NoUse,NoUse,NoUse,EndPos] = ReadData(InFilePath,1,[],'int16','float32');
[StdMatTmp1,NoUse,NoUse,NoUse,EndPos] = ReadData(InFilePath,1,[],'int16','float32',EndPos);
[TraMatTmp1,NoUse,NoUse,NoUse,EndPos] = ReadData(InFilePath,1,[],'int16','float32',EndPos);
[FlaMatTmp1,NoUse,NoUse,NoUse,EndPos] = ReadData(InFilePath,1,[],'int16','float32',EndPos);

for FileIndex=2:NFiles

	[NoUse,NoUse,InFilePath]=GetFileNameOfMat(InFileMat,FileIndex);
	[AbsMat,NoUse,NoUse,NoUse,EndPos] = ReadData(InFilePath,1,[],'int16','float32');
	[StdMat,NoUse,NoUse,NoUse,EndPos] = ReadData(InFilePath,1,[],'int16','float32',EndPos);
	[TraMat,NoUse,NoUse,NoUse,EndPos] = ReadData(InFilePath,1,[],'int16','float32',EndPos);
	[FlaMat,NoUse,NoUse,NoUse,EndPos] = ReadData(InFilePath,1,[],'int16','float32',EndPos);
	
	[m,n]=size(AbsMatTmp1);
	[p,q]=size(AbsMat);
	
	AbsMatTmp2=zeros(p,n+q);
	AbsMatTmp2(:,1:n)=AbsMatTmp1;
	AbsMatTmp2(:,n+1:n+q)=AbsMat;
	AbsMatTmp1=AbsMatTmp2;
	
	StdMatTmp2=zeros(p,n+q);
	StdMatTmp2(:,1:n)=StdMatTmp1;
	StdMatTmp2(:,n+1:n+q)=StdMat;
	StdMatTmp1=StdMatTmp2;
	
	TraMatTmp2=zeros(p,n+q);
	TraMatTmp2(:,1:n)=TraMatTmp1;
	TraMatTmp2(:,n+1:n+q)=TraMat;
	TraMatTmp1=TraMatTmp2;
	
	FlaMatTmp2=zeros(p,n+q);
	FlaMatTmp2(:,1:n)=FlaMatTmp1;
	FlaMatTmp2(:,n+1:n+q)=FlaMat;
	FlaMatTmp1=FlaMatTmp2;
	
end

[NoUse,EndPos]=SaveData(AbsMatTmp1,OutFilePath,1);
[NoUse,EndPos]=SaveData(StdMatTmp1,OutFilePath,1,[],'int16','float32',1,EndPos);
[NoUse,EndPos]=SaveData(TraMatTmp1,OutFilePath,1,[],'int16','float32',1,EndPos);
[NoUse,EndPos]=SaveData(FlaMatTmp1,OutFilePath,1,[],'int16','float32',1,EndPos);

return;
