function[OutFilePath,NTotTrials]=MergeConFiles(InFileMat,OutFilePath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	MergeConFiles.m
%
%	Markus Junghoefer	[1996]
%
%
%	Function definition
%
%
%
%==================================================================

if nargin<2; OutFilePath=[]; end;
if nargin<1; InFileMat=[]; end;

%==================================================================
DefFilePath=SetDefPath(1,'*');
[NFiles,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose Mat files:');
if NFiles<1; return; end
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
if ~strcmp(BatchPath(end),filesep); BatchPath=[BatchPath,filesep]; end
if isempty(OutFilePath)
	[OutFile,OutPath,OutFilePath]=WriteFilePath([BatchPath,'Merge.mat']);
end
if NFiles<2; return; end
pause(.1)
NTotTrials=0;
for FileIndex=1:NFiles
	[NoUse,NoUse,FilePath]=GetFileNameOfMat(InFileMat,FileIndex); 
    InData=ReadAscii(FilePath);
	NTrials=size(InData,1);
    NTotTrials=NTotTrials+NTrials;
    if FileIndex==1
        OutData=InData';
    else 
        OutData=[OutData,InData']
    end
end
SaveAscii(OutData',OutFilePath);

return;
