function[OutFilePath]=MergeMatFiles(InFileMat,OutFilePath,PreIn,PreOut,Dec,
							ReshapeStatus,NReshape,TransStatus)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	MergeMatFiles.m
%
%	Markus Junghoefer	[1996]
%
%
%	Function definition
%
%
%
%==================================================================
if nargin<8; TransStatus=0; end;
if nargin<7; NReshape=0; end;
if nargin<6; ReshapeStatus=0; end;
if nargin<5; Dec=[]; end;
if nargin<4; PreOut=[]; end;
if nargin<3; PreIn=[]; end;
if nargin<2; OutFilePath=[]; end;
if nargin<1; InFileMat=[]; end;
if isempty(PreIn);PreIn='ascii';end
if isempty(PreOut);PreOut='ascii';end
if isempty(Dec);Dec=3;end


%==================================================================

[NFiles,InFileMat]=ReadFileNames(InFileMat,'*','Choose Mat files:');
if NFiles<1; return; end

if isempty(OutFilePath)
	[OutFile,OutPath,OutFilePath]=WriteFilePath;
end
if NFiles<2; 
	[NoUse,NoUse,OutFilePath]=GetFileNameOfMat(InFileMat,1);
	return; 
end

MatTmp1=[];
MatTmp2=[];
MatchStatus=0;
for FileIndex=1:NFiles

	[NoUse,NoUse,FilePath]=GetFileNameOfMat(InFileMat,FileIndex);
	[Mat] = ReadData(FilePath,1,[],PreIn,PreIn,[],[],[],[],1,1,0);
	if TransStatus; Mat=Mat'; end
	[p,q]=size(Mat);
	[m,n]=size(MatTmp1);
	
	if FileIndex>1 & m~=p
		MatchStatus=1;
		Mat=Mat';
		[p,q]=size(Mat);
		if FileIndex==2
			MatTmp1=MatTmp1';
			[m,n]=size(MatTmp1);
		end
	end
	MatTmp2=zeros(p,n+q);
	if FileIndex>1
		MatTmp2(:,1:n)=MatTmp1;
	end
	MatTmp2(:,n+1:n+q)=Mat;
	MatTmp1=MatTmp2;
end
if MatchStatus; MatTmp1=MatTmp1'; end
if TransStatus; MatTmp1=MatTmp1'; end
[m,n]=size(MatTmp1);
if ReshapeStatus; MatTmp1=reshape(MatTmp1,m*n/NReshape,NReshape); end
SaveData(MatTmp1,OutFilePath,1,[],PreOut,PreOut,[],[],[],1,1,Dec);

return;
