function [BMat,MMat]=Mni2TalSingle(MniMat)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<1; return; end
[NPoints,NCo]=size(MniMat)
if NCo~=3; MniMat=MniMat'; end
NPoints=size(MniMat,1)
for i=1:NPoints
    MMat(i,1)=0.88.*MniMat(i,1)-0.8;	%Meyer-Lindenberg
    MMat(i,2)=0.97.*MniMat(i,2)-3.32;
    MMat(i,3)=0.05.*MniMat(i,2)+0.88.*MniMat(i,3)-0.44;
	
    BMat(i,1)=0.99.*MniMat(i,1);	%Brett
    if MniMat(i,3)>=0
	BMat(i,2)=0.9688.*MniMat(i,2)+0.046.*MniMat(i,3);
	BMat(i,3)=-0.0485.*MniMat(i,2)+0.9189.*MniMat(i,3);
    else
	BMat(i,2)=0.9688.*MniMat(i,2)+0.042.*MniMat(i,3);
	BMat(i,3)=-0.0485.*MniMat(i,2)+0.839.*MniMat(i,3);
    end
end
return
