%==================================================================
%
%	ReadData.m
%
%	Markus Junghoefer	[1996]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	
% 	Function definition
% 
% 	function [data,File,Path,FilePath,EndPos] = ReadData(FilePath,...
% 			  ReadDataStatus,string,precision1,precision2,offset,...
% 			  origin,ReadFilePathString,DefaultPath,InfoDataSize,InfoDataFile,ClearStatus,filterSpec)
% 
% 			  
%=================================================================

function [data,File,Path,FilePath,EndPos] = ReadData(FilePath,...
			  ReadDataStatus,string,precision1,precision2,offset,...
			  origin,ReadFilePathString,DefaultPath,InfoDataSize,InfoDataFile,ClearStatus,filterSpec)
	
%=================================================================
if nargin<13;filterSpec=[];end;
if nargin<12;ClearStatus=[];end;
if nargin<11;InfoDataFile=[];end;
if nargin<10;InfoDataSize=[];end;
if nargin<9;DefaultPath=[];end
if nargin<8;ReadFilePathString=[];end
if nargin<7;origin=[];end
if nargin<6;offset=[];end
if nargin<5;precision2=[];end
if nargin<4;precision1=[];end
if nargin<3;string=[];end
if nargin<2;ReadDataStatus=[];end
if nargin<1;FilePath=[];end
if ~ReadDataStatus; return; end;
	
if isempty(precision2); precision2='float32'; end
if isempty(precision1); precision1='int16'; end
if isempty(offset); offset=0; end
if isempty(origin); origin=-1; end
if isempty(InfoDataSize); InfoDataSize=1; end
if isempty(InfoDataFile); InfoDataFile=1; end
if isempty(ClearStatus); ClearStatus=1; end
if isempty(filterSpec); filterSpec='*'; end
if isempty(ReadDataStatus); ReadDataStatus=1; end

if ClearStatus; fprintf('\n'); clc; end

if isempty(string) 
	[ReadDataStatus]=IfEmptyInputBo(['Do you want to read the data Y/N ?'],[],ReadDataStatus,1);
else
	[ReadDataStatus]=IfEmptyInputBo(string,['Do you want to read this data Y/N ?'],ReadDataStatus,1);
end
if ~ReadDataStatus; return; end
if isempty(ReadFilePathString); ReadFilePathString='Please choose the data file to analyse:'; end
DefDataFilePath=SetDefPath(1,filterSpec);
[File,Path,FilePath]=ReadFilePath(FilePath,DefDataFilePath,ReadFilePathString);
if File==0
	data=[];
	File=0;
	Path=0;
	FilePath=0;
	EndPos=[];
	return;
end
	
fid=fopen(FilePath,'r','b');
if fid<3
	fprintf('Can not find the file:\n\n');
	PrintFilePath(FilePath); fprintf('  !!\n\n\n');
	[ch_TakeCancel]=IfEmptyInputSpecVal([],[1 2],1,...
					['Do you want to take a different file   [1]'],...
					['or do you want to return ?             [2]']);
	if ch_TakeCancel==1
		[File,Path]=uigetfile(filterSpec,'Read data from file:');
		FilePath=[Path,File];
		fid=fopen(FilePath,'r','b');
	elseif ch_TakeCancel==2
		data=[]; File=0; Path=0; FilePath=0; EndPos=[]; return;
	end
end

if InfoDataFile; fprintf('Start reading data from file\n\n'); 
   PrintFilePath(FilePath); fprintf('\n\n'); 
end

if isempty(origin); origin=-1; end
if isempty(offset); offset=0; end

fseek(fid,offset,origin);

if ~strcmp(precision1,'DoNotUse')
	if strcmp(precision1,'2ascii') | strcmp(precision1,'ascii')
		SizeData=fscanf(fid,'%g',[1 2]);
	elseif strcmp(precision1,'1ascii')
		m=fscanf(fid,'%g',1);
		n=1;
		SizeData=[m n];
	else
		m=fread(fid,1,precision1);
		n=fread(fid,1,precision1);
		SizeData=[m n];
	end
else
	SizeData=[];
end
if isempty(SizeData)	
	if strcmp(precision2,'ascii')	
		data=fscanf(fid,'%g');
	else
		data=fread(fid,inf,precision2);
	end
else
	if strcmp(precision2,'ascii')	
		data=fscanf(fid,'%g',SizeData);
	else
		data=fread(fid,precision2);
		%data=fread(fid,[m,n],precision2);
	end
end
EndPos=ftell(fid)
if InfoDataFile; fprintf('End reading data from file...\n\n'); end
fclose(fid);	
SaveData(data,[FilePath,'.l'],1)
return;
