function[Data,NChan,NPoint,NTrial]=ReadStoneData(FilePath);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%==================================================================
%
%	ReadStoneData.m
%
%	Markus Junghoefer	[2000]
%
%
%	Function definition
%	
%
%
%=================================================================

%==================================================================
if nargin<1; FilePath=[]; end

DefFilePath=SetDefPath(1,'*.bin');
[NFiles,FileMat,VersionString,BatchFilePath]=ReadFileNames(FilePath,DefFilePath,'Choose Stone file(s):');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);

for FileInd=1:NFiles
	[File,Path,FilePath]=GetFileNameOfMat(FileMat,FileInd);
	fid=fopen(FilePath,'r','b');
	DataSizeVec=fread(fid,3,'int32');
	NByte=DataSizeVec(1);
	NPoint=DataSizeVec(2);
	NChan=DataSizeVec(3);	
	fseek(fid,0,1);
	Tell=ftell(fid);
	NTrial=Tell./(NChan.*NPoint.*2+12);
	fseek(fid,0,-1);
	Mat=zeros(NTrial,NChan,NPoint);
	for TrialInd=1:NTrial
		fseek(fid,12,0);
		Tmp=fread(fid,[NChan NPoint],'int16');
		Mat(TrialInd,:,:)=Tmp(:,:);
	end
	fclose(fid);
	SaveFilePath=[FilePath(1:length(FilePath)-3) 'E1'];
	WriteMat2EGIS(Mat,SaveFilePath);
end
return;
