%==================================================================
%
%	ReadWeightEditMat.m
%
%	Markus Junghoefer	[1996]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	
%	Function definition

	function [WeightEditMat,SumWeightEditMat,MinWeightEdit,ch_UseWeightEditMat] = ReadWeightEditMat(DataFilePath);
	
%=================================================================
[ch_UseWeightEditMat]=IfEmptyInputBo('Do you want to use the WeightEditMat ?',[],[],1,1);
if ~ch_UseWeightEditMat; WeightEditMat=[]; MinWeightEdit=[]; return; end

fprintf('\');clc;fprintf(['Please choose the WE- Mat !']);pause(1);
[WeightEditMat,WeightEditMatFile,WeightEditMatPath,WeightEditMatFilePath] = ReadData([],1,['Read WE- Mat from file...'],[],[],[],[],[],[],[],[],0,'*.WE');
[NChan,NTrials]=size(WeightEditMat);

SumWeightEditMat=sum(WeightEditMat);
MinSumWeightEditMat=min(SumWeightEditMat);
MaxSumWeightEditMat=max(SumWeightEditMat);
MedSumWeightEditMat=median(SumWeightEditMat);
MeanSumWeightEditMat=mean(SumWeightEditMat);
fprintf(1,'Median of number of good channels per trial:  %g\n',MedSumWeightEditMat)
fprintf(1,'Mean    of number of good channels per trial:  %g\n',MeanSumWeightEditMat)
again=1;FirstPlot=1;
DefMinWeightEdit=.9.*MaxSumWeightEditMat;
while again
	[MinWeightEdit]=IfEmptyInputValInt('Please insert the minimum "good value" in one trial:',[],[],DefMinWeightEdit,MinSumWeightEditMat,MaxSumWeightEditMat,0);
	GoodTrials=find(SumWeightEditMat>MinWeightEdit);  NGoodTrials=length(GoodTrials);
	BadTrials=find(SumWeightEditMat<=MinWeightEdit);  NBadTrials=length(BadTrials);
	WeightTrialStatus=zeros(NTrials,1);
	WeightTrialStatus(GoodTrials)=ones(NGoodTrials,1);
		
	fprintf(1,'Number of bad trials with this MinWeightEdit: %g\n',NBadTrials)
	fprintf(1,'Number of good trials with this MinWeightEdit: %g\n\n\n',NGoodTrials)
	if FirstPlot
		HistFig=figure('Units','normal','NumberTitle','off','Position',[.666,0,.333,.333],'Name','Hist of SumWeightEditVec');
		FirstPlot=0;
	else
		clf;
		figure(HistFig);
	end
	x=[1:MaxSumWeightEditMat];
	[n,x]=hist(SumWeightEditMat,x);
	[xb,yb]=bar(x,n);
	plot(xb,yb)
	hold on
	plot([0 xb(length(xb))], [0 0],'w--')
	axis([x(1) x(length(x)) 0 max(yb)])
	line('XData',[MinWeightEdit MinWeightEdit],'YData',[ 0 max(yb)],'Color','r','LineStyle','--');
	%text('Units','normal','Position',[0 .05],'String',num2str(round(Lim)),'FontSize',[12]);
	[again]=IfEmptyInputBo('Again ?',[],[],1,0);
end
close(HistFig);

return;
