NBlock=36
NPicPerBlock=6
NSecPerPic=2
TotTime=NBlock*NPicPerBlock*NSecPerPic/60

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
NewPath='Paul:Movies:Stroop:NameMovie:';
OldPath='Paul:Movies:Stroop:Pics:';
ISIFile='ISI.JPG';
ISIFilePath=['"Paul:Movies:Stroop:Pics:ISI.JPG"'];

PicMat=char('RotRot.jpg');				%1
PicMat=char(PicMat,'GruenGruen.jpg');	%2
PicMat=char(PicMat,'BlauBlau.jpg');		%3
PicMat=char(PicMat,'GruenRot.jpg');		%4
PicMat=char(PicMat,'BlauGruen.jpg');	%5
PicMat=char(PicMat,'RotBlau.jpg');		%6
PicMat=char(PicMat,'4xRot.jpg');		%7
PicMat=char(PicMat,'4xGruen.jpg');		%8
PicMat=char(PicMat,'4xBlau.jpg');		%9
PicMat=char(PicMat,'RotWeiss.jpg');		%10
PicMat=char(PicMat,'GruenWeiss.jpg');	%11
PicMat=char(PicMat,'BlauWeiss.jpg');	%12

ReadRand=1

if ReadRand
	SaveMat=ReadAscii(['Paul:Movies:Stroop:Stats:RandRead'])
	BlockVec=SaveMat(:,1)';
	RandMat=SaveMat(:,2:NPicPerBlock+1);
else
	RandVec=randperm(NBlock);
	Tmp1=find(floor(RandVec/2)==RandVec/2);
	Tmp2=find(floor(RandVec/2)~=RandVec/2);
	RandVec(Tmp1)=ones(size(Tmp1))
	RandVec(Tmp2)=zeros(size(Tmp2))

	BlockVec=1
	for BlockInd=2:NBlock
		if BlockVec(BlockInd-1)==1
			if RandVec(BlockInd)
				BlockVec(BlockInd)=2;
			else
				BlockVec(BlockInd)=3;
			end
		elseif BlockVec(BlockInd-1)==2
			if RandVec(BlockInd)
				BlockVec(BlockInd)=1;
			else
				BlockVec(BlockInd)=3;
			end
		elseif BlockVec(BlockInd-1)==3
			if RandVec(BlockInd)
				BlockVec(BlockInd)=1;
			else
				BlockVec(BlockInd)=2;
			end
		end
	end
	BlockVec=BlockVec

	RandMat=zeros(NBlock,NPicPerBlock);
	for i=1:NBlock;
		RandMat(i,:)=randperm(NPicPerBlock);
		Tmp=find(RandMat(i,:)==4); 
		RandMat(i,Tmp)=1;
		Tmp=find(RandMat(i,:)==5);
		RandMat(i,Tmp)=2;
		Tmp=find(RandMat(i,:)==6);
		RandMat(i,Tmp)=3;
	end
	SaveMat=zeros(NBlock,NPicPerBlock+1);
	SaveMat(:,1)=BlockVec';
	SaveMat(:,2:NPicPerBlock+1)=RandMat;
	SaveAscii(SaveMat,['Paul:Movies:Stroop:Stats:RandName'])
end

 
% %Baseline
% for PicInd=1:NPicPerBlock
% 	OldFilePath=['"' OldPath,deblank(PicMat(RandMat(1,PicInd),:)) '"']
% end

NPic=NBlock*NPicPerBlock*2
PicIndTmp=0
for BlockInd=1:NBlock
	if BlockVec(BlockInd)==1		%Neutral
		PicIndVec=[7 8 9];
		disp('Neutral')
	elseif BlockVec(BlockInd)==2	%Kon
		PicIndVec=[1 2 3];
		disp('Kon')
	elseif BlockVec(BlockInd)==3	%InKon
		PicIndVec=[4 5 6];
		disp('InKon')
	end
	PicMatTmp=PicMat(PicIndVec,:)
	for PicInd=1:NPicPerBlock
		PicIndTmp=PicIndTmp+1;
		%=====
		CopyResult=applescript('acopy','itemName',ISIFilePath,'folderName',['"' NewPath '"']);
		if PicIndTmp<10
			NewFile=['000' int2str(PicIndTmp) '.jpg'];
		elseif PicIndTmp>9 & PicIndTmp<100
			NewFile=['00' int2str(PicIndTmp) '.jpg'];
		elseif PicIndTmp>99 & PicIndTmp<1000
			NewFile=['0' int2str(PicIndTmp) '.jpg'];
		elseif PicIndTmp>999 & PicIndTmp<10000
			NewFile=[int2str(PicIndTmp) '.jpg'];
		end
		NewFile=['"' NewFile '"'];
		CopyFilePath=['"' NewPath,ISIFile '"'];
		RenameResult = applescript('arename','itemName',CopyFilePath,'newName',NewFile);
		fprintf('Picture: %g of %g; \n',PicIndTmp,NPic);
		fprintf('Result of acopy:  '); fprintf(CopyResult); fprintf('\n');
		fprintf('Copied File:  '); fprintf(ISIFile); fprintf('\n');
		fprintf('Result of arename:  '); fprintf(RenameResult); fprintf('\n');
		fprintf('Renamed File:  '); fprintf(NewFile); fprintf('\n');
		%=======
		PicIndTmp=PicIndTmp+1;
		OldFile=deblank(PicMatTmp(RandMat(BlockInd,PicInd),:));
		OldFilePath=['"' OldPath,OldFile '"'];
		CopyResult=applescript('acopy','itemName',OldFilePath,'folderName',['"' NewPath '"']);
		if PicIndTmp<10
			NewFile=['000' int2str(PicIndTmp) '.jpg'];
		elseif PicIndTmp>9 & PicIndTmp<100
			NewFile=['00' int2str(PicIndTmp) '.jpg'];
		elseif PicIndTmp>99 & PicIndTmp<1000
			NewFile=['0' int2str(PicIndTmp) '.jpg'];
		elseif PicIndTmp>999 & PicIndTmp<10000
			NewFile=[int2str(PicIndTmp) '.jpg'];
		end
		CopyFilePath=['"' NewPath,OldFile '"'];
		NewFile=['"' NewFile '"'];
		RenameResult = applescript('arename','itemName',CopyFilePath,'newName',NewFile);
		fprintf('Picture: %g of %g; \n',PicIndTmp,NPic);
		fprintf('Result of acopy:  '); fprintf(CopyResult); fprintf('\n');
		fprintf('Copied File:  '); fprintf(OldFile); fprintf('\n');
		fprintf('Result of arename:  '); fprintf(RenameResult); fprintf('\n');
		fprintf('Renamed File:  '); fprintf(NewFile); fprintf('\n');
	end
end
