%==================================================================
%
%	TestChanGain.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
	
	function[MaxChanGainDiff,MaxChanZeroDiff]=TestChanGain(ChanGain,ChanZero);


%
%
%=================================================================
if nargin<2; ChanZero=[]; end
if nargin<1; ChanGain=[]; return; end
fprintf('\n');clc;
if all(ChanZero==0); 
	fprintf('ChanZero(:) == 0 !!!\n\n'); 
	MaxChanZeroDiff=0;
else
	TestChanZero=norm_1(ChanZero',4,[],1,2);
	NormChanZero=TestChanZero./mean(TestChanZero);
	MaxChanZeroDiff=max(abs([max(NormChanZero) min(NormChanZero)]))-1;
	fprintf('Maximum diff between channel zeros: %g per hundred !!!\n\n',MaxChanZeroDiff.*100);
end
if all(ChanGain==1); 
	fprintf('ChanGain(:) == 1 !!!\n\n'); 
	MaxChanGainDiff=0;
else
	NormChanGain=ChanGain./mean(ChanGain);
	MaxChanGainDiff=max(abs([max(NormChanGain) min(NormChanGain)]))-1;
	fprintf('Maximum diff between channel gains: %g per hundred !!!\n\n',MaxChanGainDiff.*100);
end
	
pause(1); 
	

return;
