function[NM1RawFileMat]=TestRawFiles(RawFileMat,MaxMemory);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	TestRawFiles.m
%
%	Markus Junghoefer	[2004]
%
%
%	Function definition
%
%	
%
%==================================================================
if nargin<2; MaxMemory=20; end;
if nargin<1; NRawFileMat=[]; end;

DefDataFilePath=SetDefPath('r','.RAW');
[NNetFiles,RawFileMat,NonUse,BatchFilePath]=ReadFileNames(RawFileMat,DefDataFilePath,'Choose a NetStation RAW file:');
SetDefPath('w',BatchFilePath);
NM1RawFileMat=[];
for FileInd=1:NNetFiles
    [NoUse,NoUse,NetFilePath]=GetFileNameOfMat(RawFileMat,FileInd);
    [NoUse,NoUse,NoUse,NoUse,NoUse,NoUse,NoUse,NoUse,NoUse,NoUse,NoUse, ...
    SampRateTmp,NChan]=ReadNetHeader(NetFilePath,0);
    if any(NChan-[65,129,257]==0)
        NRaw2NM1RawStatus(FileInd)=1;
    else
        NRaw2NM1RawStatus(FileInd)=0;
    end
end
if any(NRaw2NM1RawStatus)
    NRaw2NM1RawIndVec=find(NRaw2NM1RawStatus);
    NRaw2NM1RawFileMat=RawFileMat(NRaw2NM1RawIndVec,:);
    [NRaw2NM1RawFiles,NonUse]=size(NRaw2NM1RawFileMat);
	fprintf(1,'\n'); clc;
    Message=char(' ');
	if NRaw2NM1RawFiles==1
		Message=char(Message,['Extract last sensor of the following RAW file:']);
		fprintf(1,'Extract last sensor of the following RAW file:\n\n');
	else
		Message=char(Message,['Extract last sensor of the following ',int2str(NRaw2NM1RawFiles),' RAW files:']);
		fprintf(1,'Extract last sensor of the following %g RAW files:\n\n',NRaw2NM1RawFiles);
	end
	Message=char(Message,' ');
	Message=char(Message,NRaw2NM1RawFileMat);
	Message=char(Message,'');
	Message=char(Message,'');
	hmsgbox=msgbox(Message,'Info','help'); 
    [NRaw2NM1RawFileMat]=NRaw2NM1Raw(NRaw2NM1RawFileMat,MaxMemory);
end   
return;