%==================================================================
%
%	WriteFastWordSce.m
%
%
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%	
%	Function definition

function [PicFilePath,SaveFilePath]=WriteFastWordsSce(SaveFilePath,BlockFilePath)

%=================================================================
if nargin<2;
	BlockFilePath=[]; 
end;
if nargin<1;
	SaveFilePath=[]; 
end;

if isempty(SaveFilePath)
	[SaveFile,SavePath]=uiputfile('*.sce','Please choose *.sce output file name:');
	SaveFilePath=[SavePath,SaveFile]
end
BlockOrderMat=[
1 2 3 4 5 2 1 4 3 5 1 2 3 4 5 2 1 4 3 5;
3 4 1 2 5 4 3 2 1 5 3 4 1 2 5 4 3 2 1 5;
2 1 5 4 3 1 2 5 3 4 2 1 5 4 3 1 2 5 3 4;
4 3 5 2 1 3 4 5 1 2 4 3 5 2 1 3 4 5 1 2];

[NSess,NBlock]=size(BlockOrderMat);
Sess=1;
BlockOrder=BlockOrderMat(Sess,:);

% 1024(MaxSlices)/40(4Vols*10Slices)=25.6/NCond(5)=5 blocks per cond => 5.*5.*40=1000 => 2 Vols Baseline = 10 Words
StrMat=char('Stri','Pseu','Funk','Inha');
NWordTot=32;
NBaseWords=10;
NWordInBlock=20;
NBlockPerCond=5;
NCond=5;
WordVec=[];
WordMat=zeros(NBlockPerCond,NWordInBlock);
for i=1:NBlockPerCond
	WordVec=[WordVec,1:NWordTot];
	WordMat(i,:)=WordVec((i-1).*NWordInBlock+1:i.*NWordInBlock);
end

fid=fopen(SaveFilePath,'w');

fprintf(fid,'screen_width = 640;\n');
fprintf(fid,'screen_height = 480;\n');
fprintf(fid,'screen_bit_depth = 16;\n');
fprintf(fid,'default_background_color = 0,0,0;\n');
fprintf(fid,'no_logfile = false;\n');
fprintf(fid,'active_buttons = 1;\n');
fprintf(fid,'button_codes = 1;\n');
fprintf(fid,'\n');
fprintf(fid,'begin;\n');
fprintf(fid,'picture{bitmap { filename = "fixation.bmp"; };x=0;y=0;} fix;\n');
fprintf(fid,'\n');
fprintf(fid,'trial {\n');
fprintf(fid,'trial_type=first_response;\n');    
fprintf(fid,'trial_duration=forever;\n');   
fprintf(fid,'picture fix;\n');     
fprintf(fid,'code="fixation";\n');
fprintf(fid,'duration=next_picture;\n');
fprintf(fid,'}show_fix;\n');
fprintf(fid,'\n');
fprintf(fid,'box {color = 0,0,0;width = 10;height = 10;} nixbox;\n');
fprintf(fid,'picture{ box nixbox; x= 0;  y = 0;} default;\n');
fprintf(fid,'trial {picture default;} wait;\n');  
fprintf(fid,'\n');

for BaseInd=1:NBase
	i=(BaseInd-1).*4+1;
	if i<10
		iStr=['00',int2str(i)];
	elseif i>9 & i<100
		iStr=['0',int2str(i)];
	end
	fprintf(fid,['bitmap { filename = "FunkBase',iStr,'.BMP"; } aFunkBase',iStr,';\n']);
	fprintf(fid,['bitmap { filename = "PseuBase',iStr,'.BMP"; } aPseuBase',iStr,';\n']);
	fprintf(fid,['bitmap { filename = "InhaBase',iStr,'.BMP"; } aInhaBase',iStr,';\n']);
	fprintf(fid,['bitmap { filename = "StriBase',iStr,'.BMP"; } aStriBase',iStr,';\n']);
end
fprintf(fid,'\n\n\n\n');

for i=1:NWordTot
	if i<10
		iStr=['00',int2str(i)];
	elseif i>9 & i<100
		iStr=['0',int2str(i)];
	end
	fprintf(fid,['bitmap { filename = "Stri',iStr,'.BMP"; } aStri',iStr,';\n']);
	fprintf(fid,['bitmap { filename = "Funk',iStr,'.BMP"; } aFunk',iStr,';\n']);
	fprintf(fid,['bitmap { filename = "Pseu',iStr,'.BMP"; } aPseu',iStr,';\n']);
	fprintf(fid,['bitmap { filename = "Inha',iStr,'.BMP"; } aInha',iStr,';\n']);
end
fprintf(fid,'\n\n\n\n');

for BaseInd=1:NBase
	i=(BaseInd-1).*4+1;
	if i<10
		iStr=['00',int2str(i)];
	elseif i>9 & i<100
		iStr=['0',int2str(i)];
	end
	fprintf(fid,['picture {bitmap aFunkBase',iStr,';x =0;y=0;} bFunkBase',iStr,';\n']);
	fprintf(fid,['picture {bitmap aPseuBase',iStr,';x =0;y=0;} bPseuBase',iStr,';\n']);
	fprintf(fid,['picture {bitmap aInhaBase',iStr,';x =0;y=0;} bInhaBase',iStr,';\n']);
	fprintf(fid,['picture {bitmap aStriBase',iStr,';x =0;y=0;} bStriBase',iStr,';\n']);
end
fprintf(fid,'\n\n\n\n');

for i=1:NWordTot
	if i<10
		iStr=['00',int2str(i)];
	elseif i>9 & i<100
		iStr=['0',int2str(i)];
	end
	fprintf(fid,['picture {bitmap aPseu',iStr,';x =0;y=0;} bPseu',iStr,';\n']);
	fprintf(fid,['picture {bitmap aStri',iStr,';x =0;y=0;} bStri',iStr,';\n']);
	fprintf(fid,['picture {bitmap aInha',iStr,';x =0;y=0;} bInha',iStr,';\n']);
	fprintf(fid,['picture {bitmap aFunk',iStr,';x =0;y=0;} bFunk',iStr,';\n']);
end
fprintf(fid,'\n\n\n\n');

fprintf(fid,'\n\n\n\n');
fprintf(fid,'trial show_fix;\n');
fprintf(fid,'\n\n\n\n');

for BaseInd=1:NBase
	i=(BaseInd-1).*4+1;
	if i<10
		iStr=['00',int2str(i)];
	elseif i>9 & i<100
		iStr=['0',int2str(i)];
	end
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bFunkBase',iStr,'" "bFunkBase',iStr,'";};\n']);
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bPseuBase',iStr,'" "bPseuBase',iStr,'";};\n']);
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bInhaBase',iStr,'" "bInhaBase',iStr,'";};\n']);
	fprintf(fid,['TEMPLATE "alterwords.tem" { Bild ISSN ;"bStriBase',iStr,'" "bStriBase',iStr,'";};\n']);
end
fprintf(fid,'\n\n\n\n');

for BlockInd=1:NBlock
	Block=BlockOrder(BlockInd);
	BlockCount=length(find(BlockOrder==Block));
	WordVec=WordMat(BlockCount,randperm(NWordInBlock));
	for WordInd=1:NWordInBlock
		if Block==5
			PrintStr=['TEMPLATE "alterwords.tem" { Bild ISSN ;"black" "black";};\n']
		else
			CondStr=StrMat(Block,:);
			i=WordVec(WordInd);
			if j<10
				iStr=['00',int2str(i)];
			elseif i>9 & i<100
				iStr=['0',int2str(i)];
			end
			PrintStr=['TEMPLATE "alterwords.tem" { Bild ISSN ;"b',CondStr,iStr,'" "b',CondStr,iStr,'";};\n']
		end
		fprintf(fid,PrintStr);
	end
end
fprintf(fid,'\n\n\n\n');
fprintf(fid,'\n\n\n\n');
fprintf(fid,'trial show_fix;\n');
fprintf(fid,'\n\n\n\n');

fclose(fid);
return;
