%==================================================================
%
%	WritePresenSce.m
%
%	Markus Junghoefer	[2002]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	
%	Function definition

function [PicFilePath,SaveFilePath]=WritePresenSce(PicFilePath1,PicFilePath2,SaveFilePath)
	
%=================================================================
if nargin<4;SaveFilePath=[]; end;
if nargin<2;PicFilePath2=[]; end;
if nargin<1;PicFilePath1=[]; end;
	
if isempty(PicFilePath1)
	[PicFile1,PicPath1]=uigetfile('*', 'Please choose the first pic file:');
	PicFilePath1=[PicPath1,PicFile1];
end
if isempty(PicFilePath2)
	[PicFile2,PicPath2]=uigetfile('*', 'Please choose the second pic file:');
	PicFilePath2=[PicPath2,PicFile2];
end
if isempty(SaveFilePath)
	[SaveFile,SavePath]=uiputfile('*.sce','Please choose a .sce file name:');
	SaveFilePath=[SavePath,SaveFile]
end

NPic1=1;
fid=fopen(PicFilePath1,'r');
line = fgetl(fid);
PicStr1=char(line);
while 1
   line = fgetl(fid);
   if ~isstr(line), break, end
   PicStr1=char(PicStr1,line);
   NPic1=NPic1+1;
   disp(line)
end
fclose(fid);

NPic2=1;
fid=fopen(PicFilePath2,'r');
line = fgetl(fid);
PicStr2=char(line);
while 1
   line = fgetl(fid);
   if ~isstr(line), break, end
   PicStr2=char(PicStr2,line);
   NPic2=NPic2+1;
   disp(line)
end
fclose(fid);


fid=fopen(SaveFilePath,'w');

fprintf(fid,'screen_width = 640;\n');
fprintf(fid,'screen_height = 480;\n');
fprintf(fid,'screen_bit_depth = 16;\n');
fprintf(fid,'default_background_color = 0,0,0;\n');
fprintf(fid,'no_logfile = false;\n');
fprintf(fid,'active_buttons = 1;\n');
fprintf(fid,'button_codes = 1;\n');
fprintf(fid,'\n');
fprintf(fid,'begin;\n');
fprintf(fid,'picture{bitmap { filename = "fixation.bmp"; };x=0;y=0;} fix;\n');
fprintf(fid,'\n');
fprintf(fid,'trial {\n');
fprintf(fid,'trial_type=first_response;\n');    
fprintf(fid,'trial_duration=forever;\n');   
fprintf(fid,'picture fix;\n');     
fprintf(fid,'code="fixation";\n');
fprintf(fid,'duration=next_picture;\n');
fprintf(fid,'}show_fix;\n');
fprintf(fid,'\n');
fprintf(fid,'box {color = 0,0,0;width = 10;height = 10;} nixbox;\n');
fprintf(fid,'picture{ box nixbox; x= 0;  y = 0;} default;\n');
fprintf(fid,'trial {picture default;} wait;\n');  
fprintf(fid,'\n');

fprintf(fid,'bitmap { filename = "000.BMP"; } a000;\n');
fprintf(fid,'bitmap { filename = "001.BMP"; } a001;\n');
fprintf(fid,'bitmap { filename = "002.BMP"; } a002;\n');
fprintf(fid,'bitmap { filename = "003.BMP"; } a003;\n');
fprintf(fid,'bitmap { filename = "004.BMP"; } a004;\n');
fprintf(fid,'bitmap { filename = "005.BMP"; } a005;\n');
fprintf(fid,'bitmap { filename = "006.BMP"; } a006;\n');
fprintf(fid,'bitmap { filename = "007.BMP"; } a007;\n');
fprintf(fid,'bitmap { filename = "008.BMP"; } a008;\n');
fprintf(fid,'bitmap { filename = "009.BMP"; } a009;\n');

for i=1:NPic1
	fprintf(fid,['bitmap { filename = "',deblank(PicStr1(i,:)),'.BMP"; } a',deblank(PicStr1(i,:)),';\n']);
end
fprintf(fid,'\n\n\n\n');

fprintf(fid,'picture {bitmap a000 ;x =0;y=0;} b000;\n');
fprintf(fid,'picture {bitmap a001 ;x =0;y=0;} b001;\n');
fprintf(fid,'picture {bitmap a002 ;x =0;y=0;} b002;\n');
fprintf(fid,'picture {bitmap a003 ;x =0;y=0;} b003;\n');
fprintf(fid,'picture {bitmap a004 ;x =0;y=0;} b004;\n');
fprintf(fid,'picture {bitmap a005 ;x =0;y=0;} b005;\n');
fprintf(fid,'picture {bitmap a006 ;x =0;y=0;} b006;\n');
fprintf(fid,'picture {bitmap a007 ;x =0;y=0;} b007;\n');
fprintf(fid,'picture {bitmap a008 ;x =0;y=0;} b008;\n');
fprintf(fid,'picture {bitmap a009 ;x =0;y=0;} b009;\n');

for i=1:NPic1
	fprintf(fid,['picture {bitmap a',deblank(PicStr1(i,:)),';x =0;y=0;} b',deblank(PicStr1(i,:)),';\n']);
end
fprintf(fid,'\n\n\n\n');
fprintf(fid,'trial show_fix;\n');
fprintf(fid,'\n\n\n\n');

fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b000" "b000";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b001" "b001";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b002" "b002";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b003" "b003";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b004" "b004";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b005" "b005";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b006" "b006";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b007" "b007";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b008" "b008";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b009" "b009";};\n');

for i=1:NPic1
	fprintf(fid,['TEMPLATE "alterpix.tem" { Bild ISSN ;"b',deblank(PicStr1(i,:)),'" "b',deblank(PicStr1(i,:)),'";};\n']);
end
fprintf(fid,'\n\n\n\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b000" "b000";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b001" "b001";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b002" "b002";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b003" "b003";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b004" "b004";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b005" "b005";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b006" "b006";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b007" "b007";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b008" "b008";};\n');
fprintf(fid,'TEMPLATE "alterpix_count.tem" { Bild ISSN ;"b009" "b009";};\n');
for i=1:NPic2
	fprintf(fid,['TEMPLATE "alterpix.tem" { Bild ISSN ;"b',deblank(PicStr2(i,:)),'" "b',deblank(PicStr2(i,:)),'";};\n']);
end
fprintf(fid,'trial show_fix;\n');
fprintf(fid,'\n\n\n\n');

fclose(fid);
return;
