%==================================================================
%
%	AddFileName2Mat
%
%	Markus Junghoefer	[1997]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
	
	function[FileMatOut,NFileMatOut,MatlabVersionString]=AddFileName2Mat(FileMatIn,FilePathIn,DispStatus);

%
%
%=================================================================
if nargin<3; DispStatus=1; end
if nargin<2; FilePathIn=[]; end
if nargin<1; return; end

MatlabVersionString=version;
MainMatlabVersion=str2num(MatlabVersionString(1));

if isempty(FilePathIn) | ~isstr(FilePathIn)
	FileMatOut=FileMatIn; 
	[NFileMatOut,NoUse]=size(FileMatIn);
	return;
end

if isempty(FileMatIn); 
	NFileMatIn=0;
else
	[NFileMatIn,NoUse]=size(FileMatIn);
end

NFileMatOut=NFileMatIn+1;


if MainMatlabVersion<5
	LFilePathIn=length(FilePathIn);
	if isempty(FileMatIn); 
		LFileMatOut=LFilePathIn+1;
	else
		LFileMatOut=max([LFilePathIn, max(FileMatIn(:,1))])+1;
	end
	FileMatOut=zeros(NFileMatOut,LFileMatOut);
	FileMatOut(NFileMatOut,1)=LFilePathIn;
	if ~isempty(FileMatIn)
		FileMatOut(1:NFileMatIn,1)=FileMatIn(1:NFileMatIn,1);
		for FileInd=1:NFileMatIn
			FileMatOut(FileInd,2:FileMatOut(FileInd,1)+1)=FileMatIn(FileInd,2:FileMatOut(FileInd,1)+1);
		end
	end
	FileMatOut(NFileMatOut,2:LFilePathIn+1)=FilePathIn;
	fprintf('\n\n');clc;
	if DispStatus
		disp(FileMatOut(:,2:LFileMatOut));
	end
else
	if ~isempty(FileMatIn)
		FileMatOut=char(FileMatIn,FilePathIn);
	else
		FileMatOut=FilePathIn;
	end
	fprintf('\n\n');clc;
	if DispStatus
		disp(FileMatOut)
	end
end

return;
