global ParentDir StatDir Folder0 Folder1 Folder2 Folder3 Folder4 Folder5 Smooth SmoothStr MaskStr

%---------------------------------------------------------------
% model(1) Low-Off vs High Off
%---------------------------------------------------------------
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
Mask=[MaskStr,'*.img']
F1=spm_get('Files',Folder1,Mask);
F1=F1(1:100,:);
NFiles1=size(F1,1)
F2=spm_get('Files',Folder2,Mask);
F2=F2(1:100,:);
NFiles2=size(F2,1)
F3=spm_get('Files',Folder3,Mask);
F3=F3(1:100,:);
NFiles3=size(F3,1)
F4=spm_get('Files',Folder4,Mask);
F4=F4(1:100,:);
NFiles4=size(F4,1)
F5=spm_get('Files',Folder5,Mask);
F5=F5(1:100,:);
NFiles5=size(F5,1)
NFilesVec=[NFiles1 NFiles2 NFiles3 NFiles4 NFiles5]
NFiles=sum(NFilesVec)
OnVec=[0,cumsum(NFilesVec)]
F=[F1;F2;F3;F4;F5]
%---------------------------------------------------------------
% batch variables defined here for analysis 'model'
%---------------------------------------------------------------

model(1) = struct( ...
 'types',          4, ...
 'global_effects', {'None'}, ...
 'burst_mode',     0, ...
 'HF_fil',         'none',  ...
 'HF_cut',         [], ...
 'LF_fil',         'none', ...
 'LF_cut',         [], ...
 'int_corr',       'none', ... 
 'now_later',      1, ...
 'stop_writing',   0, ...
 'trial_fcon',     0, ...
 'RT',             1, ...
 'replicated',     0, ...
 'same_time_param',0, ...
 'nsess',          1, ...
 'nscans',         [NFiles], ...
 'files',          {{F}}, ...
 'conditions_nb',  [5], ...     
 'conditions',     [1], ...
 'regressors_nb',  [0], ...
 'regressors',     [], ...
 'parametrics_type',{{'none'}}, ...
 'parametrics',    [], ...
 'stochastics_flag',[0], ...
 'stochastics',    []);
 
conditions(1) = struct( ...
 'names',   {{'HighPos','LowPos','Neutral','LowNeg','HighNeg'}}, ...
 'onsets',{{OnVec(1),OnVec(2),OnVec(3),OnVec(4),OnVec(5)}}, ...   
 'types',    {{'epochs','epochs','epochs','epochs','epochs'}}, ... 
 'bf_ep',   [1 2 3 4 5], ...                                      
 'volterra',  0, ...
 'variable_dur',0);

%-------------------------------------------
bf_ep(1) = struct( ...
  'ep_type',4, ...
  'length',NFiles1, ...
  'conv',0, ...  
  'deriv',0);
%-------------------------------------------
bf_ep(2) = struct( ...
  'ep_type',4, ...
  'length',NFiles2, ...
  'conv',0, ...  
  'deriv',0);
%-------------------------------------------
bf_ep(3) = struct( ...
  'ep_type',4, ...
  'length',NFiles3, ...
  'conv',0, ...  
  'deriv',0);
%-------------------------------------------
bf_ep(4) = struct( ...
  'ep_type',4, ...
  'length',NFiles4, ...
  'conv',0, ...  
  'deriv',0);
%-------------------------------------------
bf_ep(5) = struct( ...
  'ep_type',4, ...
  'length',NFiles5, ...
  'conv',0, ...  
  'deriv',0);

IncAroLin=[4 -1 -6 -1 4];
DecAroLin=-IncAroLin;

contrasts(1)=struct('names',{{...
            'IncAroLin','DecAroLin', ...
        }},'types', {{...
            'T','T',...
        }},'values',{{...
            IncAroLin,DecAroLin, ...
            }});