%==================================================================
%
%	Calc2dTimeAxes.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%
%
%	Function definition

	function [kTop,AxesTop,kFront,AxesFront,kBack,AxesBack,kLeft,...
	          AxesLeft,kRight,AxesRight,kNorm,AxesNorm,kAll,AxesAll,...
			  TopStatusVec,FrontStatusVec,BackStatusVec,LeftStatusVec,RightStatusVec,NormStatusVec,AllStatusVec] = ...
			  Calc2dTimeAxes(EPosSpher,ChanStatusVec)


%=================================================================
if nargin<2; ChanStatusVec=[]; end
if nargin<1; EPosSpher=[]; return; end
[m,n]=size(EPosSpher);
if isempty(ChanStatusVec); 
	ChanStatusVec=ones(m,1);
else
	[m,n]=size(ChanStatusVec);
	if m==1 & n>1; ChanStatusVec=ChanStatusVec'; m=n; end
end;
ChanInd=find(ChanStatusVec==1);
NoChanInd=find(ChanStatusVec==0);
[AxesCart] = change_sphere_cart(EPosSpher, 1, 1);


TopStatusVec=zeros(m,1);
kTop=find(AxesCart(:,3)>=0);
TopStatusVec(kTop)=ones(length(kTop),1);
TopStatusVec=TopStatusVec.*ChanStatusVec;
kTop=find(TopStatusVec==1);
kNotTop=find(TopStatusVec==0);

if ~isempty(kTop)
	AxesTopTmp=AxesCart(kTop,:);
	AxesTop=zeros(length(kTop),2);
	AxesTop(:,1)=norm_1(AxesTopTmp(:,1)',1)';
	AxesTop(:,2)=norm_1(AxesTopTmp(:,2)',1)';
else
	AxesTop=[];
end


FrontStatusVec=zeros(m,1);
kFront=find(AxesCart(:,2)>=0);
FrontStatusVec(kFront)=ones(length(kFront),1);
FrontStatusVec=FrontStatusVec.*ChanStatusVec;
kFront=find(FrontStatusVec==1);
kNotFront=find(FrontStatusVec==0);

if ~isempty(kFront)
	AxesFrontTmp=AxesCart(kFront,:);
	AxesFront=zeros(length(kFront),2);
	AxesFront(:,1)=norm_1(-1.*AxesFrontTmp(:,1)',1)';
	AxesFront(:,2)=norm_1(AxesFrontTmp(:,3)',1)';
else
	AxesFront=[];
end

BackStatusVec=zeros(m,1);
kBack=find(AxesCart(:,2)<0);
BackStatusVec(kBack)=ones(length(kBack),1);
BackStatusVec=BackStatusVec.*ChanStatusVec;
kBack=find(BackStatusVec==1);
kNotBack=find(BackStatusVec==0);

if ~isempty(kBack)
	AxesBackTmp=AxesCart(kBack,:);
	AxesBack=zeros(length(kBack),2);
	AxesBack(:,1)=norm_1(AxesBackTmp(:,1)',1)';
	AxesBack(:,2)=norm_1(AxesBackTmp(:,3)',1)';
else
	AxesBack=[];
end


LeftStatusVec=zeros(m,1);
kLeft=find(AxesCart(:,1)<=0);
LeftStatusVec(kLeft)=ones(length(kLeft),1);
LeftStatusVec=LeftStatusVec.*ChanStatusVec;
kLeft=find(LeftStatusVec==1);
kNotLeft=find(LeftStatusVec==0);

if ~isempty(kLeft)
	AxesLeftTmp=AxesCart(kLeft,:);
	AxesLeft=zeros(length(kLeft),2);
	AxesLeft(:,1)=norm_1(-1.*AxesLeftTmp(:,2)',1)';
	AxesLeft(:,2)=norm_1(AxesLeftTmp(:,3)',1)';
else
	AxesLeft=[];
end


RightStatusVec=zeros(m,1);
kRight=find(AxesCart(:,1)>0);
RightStatusVec(kRight)=ones(length(kRight),1);
RightStatusVec=RightStatusVec.*ChanStatusVec;
kRight=find(RightStatusVec==1);
kNotRight=find(RightStatusVec==0);

if ~isempty(kRight)
	AxesRightTmp=AxesCart(kRight,:);
	AxesRight=zeros(length(kRight),2);
	AxesRight(:,1)=norm_1(AxesRightTmp(:,2)',1)';
	AxesRight(:,2)=norm_1(AxesRightTmp(:,3)',1)';
else
	AxesRight=[];
end

kNorm=ChanInd;
NormStatusVec=ChanStatusVec;
if ~isempty(kNorm)
	AxesNorm=zeros(length(kNorm),2);
	AxesNorm(:,1)=norm_1((EPosSpher(kNorm,1).*cos(EPosSpher(kNorm,2)))',1)';
	AxesNorm(:,2)=norm_1((EPosSpher(kNorm,1).*sin(EPosSpher(kNorm,2)))',1)';
else
	AxesNorm=[];
end

kAll=ones(m,1);
AllStatusVec=kAll;
AxesAll=zeros(m,2);
AxesAll(:,1)=norm_1((EPosSpher(:,1).*cos(EPosSpher(:,2)))',1)';
AxesAll(:,2)=norm_1((EPosSpher(:,1).*sin(EPosSpher(:,2)))',1)';
return;
