%==================================================================
%
%	CalcFFTMat.m
%
%	Markus Junghoefer	[1996]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
	
	function[FFTDataMat,PFFTDataMat,FrequResol,UseTimeWinStatus,KindTimeWin,RInt]=...
	CalcFFTMat(DataMat,SampRate,UseTimeWinStatus,KindTimeWin,RInt,PlotWinVecStatus)

%
%
%=================================================================
if nargin<6;  PlotWinVecStatus=[]; end;
if nargin<5;  RInt=[]; end;
if nargin<4;  KindTimeWin=[]; end;
if nargin<3;  UseTimeWinStatus=[];  end;
if nargin<2;  SampRate=[]; end;
if nargin<1;  return;  end;

if isempty(DataMat); return; end
TransStatus=0;
[SampRate]=IfEmptyInputVal(['Please insert the sampling rate:'],[],SampRate,250);

[NChan,NPoints]=size(DataMat);
if NChan>1 & NPoints==1; TransStatus=1; DataMat=DataMat'; end
FrequResol=SampRate./NPoints;
[DataMat,UseTimeWinStatus,KindTimeWin,RInt]=CalcFrequWin(DataMat,UseTimeWinStatus,KindTimeWin,RInt,PlotWinVecStatus);
FFTDataMat=(fft(DataMat'))';
PFFTDataMat=abs(FFTDataMat.*conj(FFTDataMat))./NPoints;
% PFFTDataPlot=PFFTDataMat(1:floor((length(PFFTDataMat)+1)./2))
% plot(PFFTDataPlot)
% axis([2 10 0 1.1.*max(PFFTDataPlot(2:10))])
if TransStatus; 
	PFFTDataMat=PFFTDataMat'; 
	FFTDataMat=FFTDataMat'; 
end
return;
