%==================================================================
%
%	ChooseChanInd.m
%
%	Markus Junghoefer	[1996]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
%
	function[ChanInd,NoChanInd,ChanStatusVec,chChooseChannelInd,CountVec]=ChooseChanInd(NChan,chChooseChannelInd,...
	ClearStatus,string1,string2,DefChooseChannelInd,EPosSpher,ENames,ChanStatusVec,ReadFilePath,...
	chReadOrCalc,chTakeKind,chSaveEStatus,chCountPairs)
%

%==================================================================
if nargin<14; chCountPairs=0; end
if nargin<13; chSaveEStatus=[]; end
if nargin<12; chTakeKind=[]; end
if nargin<11; chReadOrCalc=[]; end
if nargin<10; ReadFilePath=[]; end
if nargin<9; ChanStatusVec=[]; end
if nargin<8; ENames=[]; end
if nargin<7; EPosSpher=[]; end
if nargin<6; DefChooseChannelInd=0; end
if nargin<5; string2=[]; end
if nargin<4; string1=[]; end
if nargin<3; ClearStatus=0; end
if nargin<2; chChooseChannelInd=[]; end
if nargin<1; NChan=[]; ChanInd=[]; NoChanInd=[]; ChanStatusVec=[]; return; end

if NChan==1; ChanInd=1; NoChanInd=[]; ChanStatusVec=1; return; end

if isempty(string1); string1=['Do you want to choose special channels ? Y/N']; end

[chChooseChannelInd]=IfEmptyInputBo(string1,string2,chChooseChannelInd,DefChooseChannelInd,ClearStatus);
if ~chChooseChannelInd; ChanInd=[1:NChan]'; NoChanInd=[]; ChanStatusVec=ones(NChan,1); return; end

fprintf('\n'); clc;
fprintf('Choose special channels:\n\n\n');
[chReadOrCalc]=IfEmptyInputSpecVal(chReadOrCalc,[1 2 3],1,...
					  		['Do you want to choose an existing file                  [1]'],...
							['do you want to plot or change an existing file          [2]'],...
							['or do you want to create a new file                     [3]']);

%========================================================================

if chReadOrCalc==1 | chReadOrCalc==2
	if chReadOrCalc==1; NChanRead=NChan; else; NChanRead=[]; ReadFilePath=[]; end		
	[ChanStatusVec,ReadFile,ReadPath,ReadFilePath]=ReadEStatus(ReadFilePath,NChanRead);
	if chReadOrCalc==2
		NChanRead=length(ChanStatusVec);
		if NChanRead<NChan
			ChanStatusVecTmp=ones(NChan,1);
			ChanStatusVecTmp(1:NChanRead)=ChanStatusVec;
			ChanStatusVec=[]; ChanStatusVec=ChanStatusVecTmp; ChanStatusVecTmp=[];
		elseif NChanRead>NChan
			ChanStatusVec=ChanStatusVec(1:NChan);
		end
	end
	if ReadFile==0;
		chTakeKind=11; 
	else	
		[NChanTmp,NoUse]=size(ChanStatusVec);
		if NChanTmp==NChan
			if chReadOrCalc==2; 
				chTakeKind=20; 
			else
				ChanInd=find(ChanStatusVec==1);
				NoChanInd=find(ChanStatusVec==0);
			end
		elseif NChanTmp==NChan+1
			clc;
			fprintf('Erase the last channel status:');
			ChanStatusVecTmp=zeros(NChan,1);
			ChanStatusVecTmp=ChanStatusVec(1:NChan);
			ChanStatusVec=[]; ChanStatusVec=ChanStatusVecTmp; ChanStatusVecTmp=[];
			if chReadOrCalc==2; 
				chTakeKind=20; 
			else
				ChanInd=find(ChanStatusVec==1);
				NoChanInd=find(ChanStatusVec==0);
			end
		else
			fprintf('Bad number of channels in ChooseChannelInd !!!'); return;
		end
	end
end

if chReadOrCalc==3 
		
	%========================================================================
	fprintf('\n'); clc;
	fprintf('Start to read the channel configuration:\n\n\n')
	[chTakeKind]=IfEmptyInputSpecVal(chTakeKind,[0:19],11,...
			['Do you want to choose no channel,                          [0]'],...
			['do you want to choose all channels,                        [1]'],...
			['do you want to choose every second, third,... channel      [2]'],...
			['do you want to choose special channels                     [3]'],...
			['do you want to neglect special channels                    [4]'],...
			['do you want to take only top channels                      [5]'],...
			['do you want to take only frontal channels                  [6]'],...
			['do you want to take only back channels                     [7]'],...
			['do you want to take only left channels                     [8]'],...
			['do you want to take only right channels                    [9]'],...
			['or do you want to choose the channels graphically          [+10]']);

end

if chReadOrCalc==2 | chReadOrCalc==3

	[ENames]=SetENames(ENames,NChan);

	if chTakeKind==0 | chTakeKind==10
			ChanStatusVec=zeros(NChan,1);
	elseif chTakeKind==1 | chTakeKind==11
			ChanStatusVec=ones(NChan,1);
	elseif chTakeKind==2 | chTakeKind==12
		[tmp]=IfEmptyInputValInt(['Please insert the factor:'],['(2 = second, 3 = third,...)'],[],max(1,floor(NChan./20)),1,NChan);
		ChanInd=[1:tmp:NChan];
		ChanStatusVec=zeros(NChan,1);
		ChanStatusVec(ChanInd)=ones(length(ChanInd),1);
	elseif chTakeKind==3  | chTakeKind==13
		ChanStatusVec=zeros(NChan,1);
		TakeChan=1;
		while TakeChan~=0
			TakenChan=find(ChanStatusVec==1);
			fprintf('\n'); clc; fprintf('Please insert the number of the %g channel to take:\n',length(TakenChan)+1)	
			[TakeChan]=IfEmptyInputValInt(['(If no more to take press "0".)'],[],[],[],0,NChan);
			if TakeChan~=0
				ChanStatusVec(TakeChan)=1;
			end
		end
	elseif chTakeKind==4  | chTakeKind==14
		NeglectChan=1;
		ChanStatusVec=ones(NChan,1);
		while NeglectChan~=0
			NeglectedChan=find(ChanStatusVec==0);
			fprintf('\n'); clc; fprintf('Please insert the number of the %g channel to neglect:\n',length(NeglectedChan)+1)	
			[NeglectChan]=IfEmptyInputValInt(['(If no more to take press "0".)'],[],[],[],0,NChan);
			if NeglectChan~=0
				ChanStatusVec(NeglectChan)=0;
			end
		end	
	end
	if chTakeKind>4
		if isempty(EPosSpher)
			%fprintf('\n');clc;
			%fprintf(1,'Do you want to take the %g electrode default file ?',NChan);
			%[chTakeDefEFile]=IfEmptyInputBo([],[],[],1);
			chTakeDefEFile=1;
			if chTakeDefEFile	
				ECfgPathTmp=what('SensorCfg');
				ECfgPath=getfield(ECfgPathTmp,'path');
				ECfgFile=[int2str(NChanCalc) '.ecfg'];
				ECfgFilePath=[ECfgPath,ECfgFile];
				ExEConfigFilePath=exist(ECfgFilePath);
				if ExEConfigFilePath~=2
					fprintf('Sorry, but this file does not exist any more !');pause(2);fprintf('\n');clc		
				else
					EConfigFilePath=DefEFilePath;
				end
			end
			if ~chTakeDefEFile | (chTakeDefEFile & ExEConfigFilePath~=2)
				EConfigFilePath=[];
				fprintf('Please choose the electrode config file:')
				pause(1)
			end
			[NChanTmp,SpherRadius,EPosSpher,ENames,EConfigFile,EConfigPath,EConfigFilePath]=ReadEConfig(EConfigFilePath);
		end
		[kTop,AxesTop,kFront,AxesFront,kBack,AxesBack,kLeft,...
	     AxesLeft,kRight,AxesRight,kNorm,AxesNorm,kAll,AxesAll,...
		 TopStatusVec,FrontStatusVec,BackStatusVec,LeftStatusVec,RightStatusVec,NormStatusVec,AllStatusVec] = ...
		 Calc2dTimeAxes(EPosSpher,ChanStatusVec);
		 
		if     chTakeKind==5 | chTakeKind==15
			ChanStatusVec=TopStatusVec;
		elseif chTakeKind==6 | chTakeKind==16
			ChanStatusVec=FrontStatusVec;
		elseif chTakeKind==7 | chTakeKind==17
			ChanStatusVec=BackStatusVec;
		elseif chTakeKind==8 | chTakeKind==18
			ChanStatusVec=LeftStatusVec;
		elseif chTakeKind==9 | chTakeKind==19
			ChanStatusVec=RightStatusVec;
		end
		if chTakeKind>=10
			hfigtmp=figure('Units','normal','NumberTitle','off','MenuBar','none','Position',[0 0 .8 1],...
                'Name',['Choose special channels:'],'Color',[0 0 0]);
			hAxesTmp=axes('Position',[0.05 0.05 .9 .85],'Visible','off');
			ApplyTextPosition=[.9,.1];
			NewGroupTextPosition=[.1 -0.03];
% 			AllTextPosition=[.9,.1];
% 			NoneTextPosition=[.9,.05];

			hw=0.03;
			if chCountPairs==1
				hCountText=text('Units','normal','Position',[.5,1.05],'HorizontalAlignment','Center','Color','w','FontSize',18,'String','Please choose the first channel of your data set:');
			elseif chCountPairs==2
				hCountText=text('Units','normal','Position',[.5,1.05],'HorizontalAlignment','Center','Color','w','FontSize',18,'String','Please choose the first pair of electrodes:');
			elseif chCountPairs==3
				hCountText=text('Units','normal','Position',[.5,1.05],'HorizontalAlignment','Center','Color','w','FontSize',18,'String','Please choose the first channel of the first group:');
				text('Units','normal','Position',NewGroupTextPosition,'HorizontalAlignment','Center','Color','b','FontSize',18,'String','New Group');
				NGroups=1;
				ChanStatusMat=zeros(NChan,NGroups);
			end
			text('Units','normal','Position',[.1 .0],'HorizontalAlignment','Center','Color','r','FontSize',18,'String','Status of electrode: "Off"');
			text('Units','normal','Position',[.1 .03],'HorizontalAlignment','Center','Color','g','FontSize',18,'String','Status of electrode:  "On"');
			text('Units','normal','Position',ApplyTextPosition,'HorizontalAlignment','Center','Color','y','FontSize',20,'String','Apply');
% 			text('Units','normal','Position',AllTextPosition,'HorizontalAlignment','Center','Color','g','FontSize',20,'String','All');
% 			text('Units','normal','Position',NoneTextPosition,'HorizontalAlignment','Center','Color','r','FontSize',20,'String','None');
			
			for i=1:length(AllStatusVec)
				if ChanStatusVec(i)==0; ColorVal='r'; else; ColorVal='g'; end
				hTextVec(i)=text('Units','normal','Position',AxesAll(i,:),'HorizontalAlignment','Center','Color',ColorVal,'String',num2str(ENames(i,:)),'FontSize',18);
			end
			axis('off');
			hold off;
			ChooseChanAgain=1;
			fprintf('Please choose the channel !'); pause(1)
			
			while ChooseChanAgain==1
				[XHoriz,YVert]=ginput(1);
				if XHoriz>ApplyTextPosition(1)-2*hw & XHoriz<ApplyTextPosition(1)+2*hw & YVert>ApplyTextPosition(2)-hw & YVert<ApplyTextPosition(2)+hw
					ChooseChanAgain=0;
				elseif XHoriz>NewGroupTextPosition(1)-2*hw & XHoriz<NewGroupTextPosition(1)+2*hw & YVert>NewGroupTextPosition(2)-hw & YVert<NewGroupTextPosition(2)+hw & chCountPairs==3
					NGroups=NGroups+1
					ChanStatusMatTmp=zeros(NChan,NGroups);
					ChanStatusMatTmp(:,1:NGroups-1)=ChanStatusMat;
					ChanStatusMatTmp(:,NGroups)=ChanStatusVec;
					ChanStatusMat=ChanStatusMatTmp; ChanStatusMatTmp=[];
					CountString=['Please choose channel 1 of group ' int2str(NGroups) ':'];
					set(hCountText,'String',CountString);
					ChanStatusVec=zeros(NChan,1);
					set(hTextVec,'Color','r');
%				ChanStatusVec=ones(size(ChanStatusVec));
% 				elseif XHoriz>AllTextPosition(1)-2*hw & XHoriz<AllTextPosition(1)+2*hw & YVert>AllTextPosition(2)-hw & YVert<AllTextPosition(2)+hw
% 					ChanStatusVec=ones(size(ChanStatusVec));
% 					set(hTextVec,'Color','g');
% 				elseif XHoriz>NoneTextPosition(1)-2*hw & XHoriz<NoneTextPosition(1)+2*hw & YVert>NoneTextPosition(2)-hw & YVert<NoneTextPosition(2)+hw
% 					ChanStatusVec=zeros(size(ChanStatusVec));
% 					set(hTextVec,'Color','r');
				else
					ChanIndTmp=find(AxesAll(:,1)-hw<=XHoriz & AxesAll(:,1)+hw>=XHoriz & AxesAll(:,2)-hw<=YVert & AxesAll(:,2)+hw>= YVert);
					if isempty(ChanIndTmp);
						fprintf('\n');clc;
						fprintf('Your choose is not clear !\n\n')
					elseif length(ChanIndTmp)~=1; 
						fprintf('\n');clc;
						fprintf('Your choose is not obvious !\n\n')
					else
						ChanStatusTmp=ChanStatusVec(ChanIndTmp);
						if ChanStatusTmp==0; 
							ChanStatusVec(ChanIndTmp)=1; ColorVal='g';
						elseif ChanStatusTmp==1;
							ChanStatusVec(ChanIndTmp)=0; ColorVal='r';
						end
						set(hTextVec(ChanIndTmp),'Color',ColorVal);
						if chCountPairs==1
							NChanTmp=length(find(ChanStatusVec==1));
							CountVec(NChanTmp)=ChanIndTmp;
							CountString=['Please choose channel ' int2str(NChanTmp+1) ' : (take data order into account)'];
							set(hCountText,'String',CountString);
						elseif chCountPairs==2
							NChanTmp=length(find(ChanStatusVec==1));
							CountVec(NChanTmp)=ChanIndTmp;
							if NChanTmp>1
								CountString=['Please choose pair ' int2str((NChanTmp+1)./2) ' :'];
								set(hCountText,'String',CountString);
							end
						elseif chCountPairs==3
							NChanTmp=length(find(ChanStatusVec==1));
							CountVec(NChanTmp)=ChanIndTmp;
							CountString=['Please choose channel ' int2str(NChanTmp+1) ' of group ' int2str(NGroups) ':'];
							set(hCountText,'String',CountString);
						end
					end
				end
				if chCountPairs==2 & ChooseChanAgain==0 & mod(NChanTmp,2)~=0
					ChooseChanAgain=1;
					clc;
					fprintf('Sorry, but you have to choose an even number of electrodes !')
					pause(2)
				end
			end
			close(hfigtmp);
		end
	end
	
	%==============================================================================================
	ChanInd=find(ChanStatusVec==1);
	NoChanInd=find(ChanStatusVec==0);
	
	fprintf('\n\n')
	[chSaveEStatus]=IfEmptyInputBo(['Do you want to'],['save this choosen indices ? Y/N'],chSaveEStatus,1,0);
	SaveEStatus(ChanStatusVec,[],[],[],chSaveEStatus);
end

%==============================================================================================

return;


