function [OutFileMat]=Cnt2CntNeuroscanFiles(FileMat)
%=========================================================================================
% Transfer neuroscan data NsCntType 3 to NsCntType 1 if all data fits in memory
%=========================================================================================
if nargin<1; FileMat=[]; end

[NFiles,FileMat]=ReadFileNames(FileMat,'*.cnt','Choose NsCntType 3 Neuroscan *.cnt file(s):');
if NFiles==0; return; end
OutFileMat=FileNameExt2Mat(FileMat,'t.cnt',3);
for FileIndex=1:NFiles
    
    [OutFile,OutPath,OutFilePath]=GetFileNameOfMat(OutFileMat,FileIndex);
    [OrigFile,OrigPath,OrigFilePath]=GetFileNameOfMat(FileMat,FileIndex);
    
    NsStruct=ReadNeuroscanStruct(OrigFilePath);
    NsHeader=NsStruct.header;
    NsEvents=NsStruct.events;
    
    NChan=NsHeader.nchannels;
    NPoints=NsHeader.numsamples
    DataStart=NsHeader.datastart;
    
    NsType=NsHeader.continuoustype;
    NsBlockSize=NsHeader.fspblocksize;
    NsChannelOffset=NsHeader.channeloffset;
    
    NPointsPerBlock=NsChannelOffset./2; %./2 bytes
    NBlocks=floor(NPoints./NPointsPerBlock);
    NRestPoints=NPoints-NBlocks.*NPointsPerBlock;
    
    Message=char('Copying file:');
    Message=char(Message,' ');
    Message=char(Message,['Orig file: ',OrigFilePath]);
    Message=char(Message,['Copy file: ',OutFilePath]);
    hmsgbox=msgbox(Message,'Info:','help');
    
    [CopyStatus,CopyMsg]=copyfile(OrigFilePath,OutFilePath,'writable');
    if ~CopyStatus
        hmsgbox=msgbox(CopyMsg,'Info:','help');
    end
    pause(.1)
    OrigFid=fopen(OrigFilePath,'r','l');
    OrigFidSeekStatus=fseek(OrigFid,DataStart,'bof');
    if OrigFidSeekStatus==-1; warning('OrigFid fseek error'); pause; end
    OutFid=fopen(OutFilePath,'r+','l');
    OutFidSeekStatus=fseek(OutFid,885,'bof'); %h.continuoustype
    if OutFidSeekStatus==-1; warning('OutFid fseek error'); pause; end
    fwrite(OutFid,1,'char'); %set continuoustype=1
    OutFidSeekStatus=fseek(OutFid,DataStart,'bof');
    if OutFidSeekStatus==-1; warning('OutFid fseek error'); pause; end

    Data=zeros(NChan,NPoints);
    for BlockInd=1:NBlocks
        for ChanInd=1:NChan
            Data(ChanInd,(BlockInd-1).*NPointsPerBlock+1:BlockInd.*NPointsPerBlock)=fread(OrigFid,NPointsPerBlock,'int16')';
        end
    end
    for ChanInd=1:NChan
        Data(ChanInd,NBlocks.*NPointsPerBlock+1:NPoints)=fread(OrigFid,NRestPoints,'int16')';
         if ChanInd<NChan
            FSeekStatus=fseek(NsFid,(NPointsPerBlock-NRestPoints).*2,'cof');
            if FSeekStatus==-1; error('fseek error; NPostRestPoints'); end
        end
    end
    for i=1:NPoints
        Count=fwrite(OutFid,Data(:,i),'int16');
        if Count~=NChan; warning('Count~=NChan'); pause; end
    end
    fclose(OrigFid);
    fclose(OutFid);
end
return;
