function [FiltFileMat]=FiltTransNeuroscanFiles(FileMat,MaxMemory,LowFiltStatus,LowFrequ,LowN, 
                                          HighFiltStatus,HighFrequ,HighN,StopFiltStatus,StopFrequ,StopN)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%=========================================================================================
% FiltNeuroscanFiles filtering of cnt neuroscan data if all data fits in memory
% FiltTransNeuroscanFiles for big data sets if all data of one sensor fits in memory
%=========================================================================================
if nargin<11; StopN=6; end
if nargin<10; StopFrequ=[49 51]; end %[LineFrequ-1 LineFrequ+1];
if nargin<9; StopFiltStatus=1; end
if nargin<8; HighN=6; end
if nargin<7; HighFrequ=2; end
if nargin<6; HighFiltStatus=1; end
if nargin<5; LowN=6; end
if nargin<4; LowFrequ=40; end
if nargin<3; LowFiltStatus=1; end
if nargin<2; MaxMemory=20; end
if nargin<1; FileMat=[]; end

[NFiles,FileMat]=ReadFileNames(FileMat,'*.cnt','Choose Neuroscan *.cnt file(s):');
if NFiles==0; return; end
[TransFileMat,TRStatusOut]=TransCntTnt(FileMat,1,MaxMemory);
FiltFileMat=FileNameExt2Mat(FileMat,'f.tnt',3);
for FileIndex=1:NFiles
	
	[TransFile,TransPath,TransFilePath]=GetFileNameOfMat(TransFileMat,FileIndex);
	[FiltFile,FiltPath,FiltFilePath]=GetFileNameOfMat(FiltFileMat,FileIndex);
    [OrigFile,OrigPath,OrigFilePath]=GetFileNameOfMat(FileMat,FileIndex);
	NsStruct=ReadNeuroscanStruct(TransFilePath);
    
	NsHeader=NsStruct.header;
	NsEvents=NsStruct.events;
	
	SampRate=NsHeader.rate;
	NChan=NsHeader.nchannels
	NPoints=NsHeader.numsamples
	DataStart=NsEvents(1).offset;
		
	Message=char('Copying file:');
	Message=char(Message,' ');
	Message=char(Message,['Orig file: ',TransFilePath]);
	Message=char(Message,['Copy file: ',FiltFilePath]);
	hmsgbox=msgbox(Message,'Info:','help');
	[CopyStatus,CopyMsg]=copyfile(TransFilePath,FiltFilePath,'writable');
	if ~CopyStatus
		hmsgbox=msgbox(CopyMsg,'Info:','help');
	end
	pause(.1)
	TransFid=fopen(TransFilePath,'r','l');
	TransFidSeekStatus=fseek(TransFid,DataStart,'bof');
    if TransFidSeekStatus==-1; warning('TransFid fseek error'); pause; end
	FiltFid=fopen(FiltFilePath,'r+','l');
	FiltFidSeekStatus=fseek(FiltFid,DataStart,'bof')
    if FiltFidSeekStatus==-1; warning('FiltFid fseek error'); pause; end

	Nyquist=SampRate./2;
	
	if HighFiltStatus
		fprintf(1,'Highpass filtering of EEG data: HighFrequ: %g Hz; Order: %g;\n\n',HighFrequ,HighN);
		[BHigh,AHigh]=butter(HighN,HighFrequ./Nyquist,'high');
	end
	if LowFiltStatus
		fprintf(1,'Lowpass filtering of EEG data: LowFrequ: %g Hz; Order: %g;\n\n',LowFrequ,LowN);
		[BLow,ALow]=butter(LowN,LowFrequ./Nyquist,'low');
	end
	if StopFiltStatus
		fprintf(1,'Stopband filtering of EEG data: StopFrequ: %g - %g Hz; Order: %g;\n\n',StopFrequ(1),StopFrequ(2),StopN);
		[BLow,ALow]=butter(StopN,StopFrequ./Nyquist,'stop');
	end
	for ChanIndex=1:NChan	
		fprintf(1,'Sensor: %g\n',ChanIndex)
		DataVec=fread(TransFid,NPoints,'int16');
		if HighFiltStatus
			fprintf(1,'high ... Frequ: %g Hz; Order: %g;\n',HighFrequ,HighN);
			DataVec=filtfilt(BHigh,AHigh,DataVec);
		end
		if LowFiltStatus
			fprintf(1,'low ... Frequ: %g Hz; Order: %g;\n',LowFrequ,LowN);
			DataVec=filtfilt(BLow,ALow,DataVec);
		end
		if StopFiltStatus
			fprintf(1,'stop ... Frequ: %g Hz; Order: %g;\n',StopFrequ,StopN);
			DataVec=filtfilt(BStop,AStop,DataVec);
		end
		Count=fwrite(FiltFid,DataVec,'int16');
        if Count~=NPoints; warning('Count~=NPoints'); pause; end
	end
    fclose(TransFid);
    fclose(FiltFid);
end
[FiltFileMat,TRStatusOut]=TransCntTnt(FiltFileMat,-1,MaxMemory);
return;
