% gibt fuer unterschiedliche DF und alphas signifikanzschwelle fuer
% corrcoefs aus
%
% inputvariablen:
% laenge der zeitreihe (NPoints)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
% signifikannzlevel(alpha)
%
%
% rationale:
% fuer kleine df = kurze zeitreihe: extrapoliere aus tabellenwerten
% fuer grosse df = laengere zeitreihe: nutze student-t -> NV
function[RCrit] = FindRCrit(NPoints);

if nargin<1; NPoints=[]; end
if isempty(NPoints); RCrit=[]; return; end
NPoints=ceil(NPoints);
if NPoints<1; fprintf('NPoints<1 in  FindRCrit.m'); RCrit=[]; return; end
df = NPoints-1;

if df <= 120
        RCritVec = [0.98 0.95 0.88 0.81 0.75 0.71 0.67 0.63 0.6 0.58 0.55 ...
		0.53 0.51 0.5 0.48 0.47 0.46 0.44 0.43 0.42 0.41 0.4 0.4 0.39 0.38 0.37 ...
		0.37 0.36 0.36 [0.35:-0.005:0.3] [0.30:-0.003:0.25] [0.25:-0.00115:0.178]];
		RCrit(1) = RCritVec(df);
		
	RCritVec = [1.0 0.99 0.96 0.92 0.88 0.83 0.8 0.77 00.74 0.71 0.69 ...
		0.66 0.64 0.62 0.61 0.59 0.58 0.56 0.55 0.54 0.53 0.52 0.51 0.50 0.49 0.48 ...
		0.47 0.46 0.46 [0.45:-0.006:0.39] [0.39:-0.0031:0.325] ...
		[0.325:-0.0016:0.232]];
		RCrit(2) = RCritVec(df);
	% Standardnormalverteilung, falls df > 120
elseif df > 120
	RCrit(1) = 0.14;
	RCrit(2) = 0.19;
end

