function[File,Path,FilePath]=GetFileNameOfMat(FileMat,FileIndex);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	GetFileNameOfMat.m
%
%	Markus Junghoefer	[1996]
%
%
%	Function definition
%
% 	
% 	% 
% 
%
%=================================================================
if nargin<2; FileIndex=[]; end
if nargin<1; FileMat=[]; end
if isempty(FileMat); fprintf('Empty FileMat in GetFileNameOfMat !'); return; end
[NFiles,n]=size(FileMat);
[FileIndex]=IfEmptyInputValInt('Please choose a special file index:',[],FileIndex,1,1,NFiles,1);
FilePath=deblank(FileMat(FileIndex,:));
[File,Path]=SepFilePath(FilePath);
return;
