function [MinInd,MaxInd]=GetFrequInterval(action,Vec,Title)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<2; Title=['Wavelet Frequency Interval']; end
if nargin<2; Vec=linspace(0,50,101); end
if nargin<1; action='InitializeMenue'; end

global hGetFrequIntervalMenuFig

DefMat=[0 4 0 4;4 8 4 8;8 12 8 12; 12 16 12 16; 16 20 16 20; 20 100 20 100];
DefStrMat=char('Delta');
DefStrMat=char(DefStrMat,'Theta');
DefStrMat=char(DefStrMat,'Alpha');
DefStrMat=char(DefStrMat,'Beta I');
DefStrMat=char(DefStrMat,'Beta II');
DefStrMat=char(DefStrMat,'Gamma');

if strcmp(action,'InitializeMenue'),
	
    if ~isempty(findobj('tag','FreqIntervalMenuFig'))
        return;
    end
	NPoints=length(Vec);
	if NPoints>=10
		SliderStep=[1./NPoints 10./NPoints];
	else
		SliderStep=[.1 1];
	end
	if strcmp(computer,'MAC2')	
		MenuFigPosVec=[.8 .25 .2 .3];
	elseif strcmp(computer,'PCWIN') 
		MenuFigPosVec=[.8 .25 .2 .3];
	elseif strcmp(computer,'SOL2') | strcmp(computer,'LNX86')
		MenuFigPosVec=[.8 .25 .2 .3];			
	end;
	hGetFrequIntervalMenuFig=figure('Units','normal','Position',MenuFigPosVec, ...
	'Name',Title,'Color',[.99 .99 .99],'Userdata',Vec, ...
	'NumberTitle','off','tag','FreqIntervalMenuFig');
	
	% Information for all buttons (and menus)
	labelColor=[0.8 0.8 0.8];
	menutop=0.85;
	btnTop = 0.6;
	top=0.75;
	left=0.125;
	btnWid=0.8;
	btnHt=0.175;
	btnHt_edit=0.175;
	
	% Spacing between the button and the next command's label
	spacing=0;
	
	%====================================
	% The CONSOLE frame
	frmBorder=0.05; 
	frmLeft=left-frmBorder;
	frmBottom=.01; 
	frmHeight=.9; 
	frmWidth=btnWid+2*frmBorder;
	yPos=frmBottom-frmBorder;
	frmPos=[frmLeft frmBottom frmWidth frmHeight];
	ConsoleRGBColor=[0 0 0.3];
	hConsolFrame=uicontrol( ...
	'Style','frame', ...
	'Units','normalized', ...
	'Position',frmPos, ...
	'BackgroundColor',ConsoleRGBColor);
	
	btnNumber=1;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left yPos-btnHt_edit./2 2.*btnWid./3 btnHt_edit./2];
	
	hMinPointText = uicontrol( ...
	'Style','text', ...
	'Units','normalized', ...
	'Position',btnPos, ...
	'Horiz','left', ...
	'Foreground','black', ...
	'String','Min. frequ. [Hz]; # 1',...
	'Enable','on');
	
	btnPos=[left+2.*btnWid./3 yPos-btnHt_edit./2 btnWid./3 btnHt_edit./2];
	callbackStr = 'GetFrequInterval(''setMinPoint'')';
	
	hMinPointMenu = uicontrol( ...
	'Style','edit', ...
	'Units','normalized', ...
	'Position',btnPos, ...
	'Horiz','center', ...
	'Background','white', ...
	'Foreground','black', ...
	'String',num2str(round(Vec(1).*100)./100),...
	'Value',Vec(1),...
	'callback',callbackStr,...
	'Enable','on');
	
	%MinPointSlider
	btnPos=[left yPos-btnHt_edit btnWid btnHt_edit./2];
	callbackStr = 'GetFrequInterval(''setMinPointSlider'')';
	hMinPointSlider=uicontrol( ...
	'Style','slider', ...
	'Units','normalized', ...
	'Position',btnPos, ...
	'String','Min. Point', ...
	'HorizontalAlignment','center',...
	'Value',1, ...
	'Userdata',[], ...
	'Min',1, ...
	'Max',NPoints, ...
	'SliderStep',SliderStep, ...
	'Callback',callbackStr,...
	'Enable','on');
	
	%===================================
	
	% MaxPointHandle
	btnNumber=2;    
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left yPos-btnHt_edit./2 2.*btnWid./3 btnHt_edit./2];
	
	hMaxPointText = uicontrol( ...
	'Style','text', ...
	'Units','normalized', ...
	'Position',btnPos, ...
	'Horiz','left', ...
	'Foreground','black', ...
	'String',['Max. frequ. [Hz]; # ',int2str(NPoints)],...
	'Enable','on');
	
	btnPos=[left+2.*btnWid./3 yPos-btnHt_edit./2 btnWid./3 btnHt_edit./2];
	callbackStr = 'GetFrequInterval(''setMaxPoint'')';
	
	hMaxPointMenu = uicontrol( ...
	'Style','edit', ...
	'Units','normalized', ...
	'Position',btnPos, ...
	'Horiz','center', ...
	'Background','white', ...
	'Foreground','black', ...
	'String',num2str(round(Vec(NPoints).*100)./100),...
	'Value',NPoints,...
	'callback',callbackStr,...
	'Enable','on');
	
	%MaxPointSlider
	btnPos=[left yPos-btnHt_edit btnWid btnHt_edit./2];
	callbackStr = 'GetFrequInterval(''setMaxPointSlider'')';
	hMaxPointSlider=uicontrol( ...
	'Style','slider', ...
	'Units','normalized', ...
	'Position',btnPos, ...
	'String','Max. Point', ...
	'HorizontalAlignment','center',...
	'Userdata',[], ...
	'Value',NPoints, ...
	'Min',1, ...
	'Max',NPoints, ...
	'SliderStep',SliderStep, ...
	'Callback',callbackStr,...
	'Enable','on');
	
	%===================================
	for BandInd=1:size(DefMat,1)
		btnNumber=3+floor((BandInd-1)./2); 
		yPos=menutop-(btnNumber-1)*(btnHt+spacing);	
		if floor(BandInd./2).*2~=BandInd
			btnPos=[left yPos-btnHt_edit./2 btnWid./2 btnHt_edit./2];
		else
			btnPos=[left+btnWid./2 yPos-btnHt_edit./2 btnWid./2 btnHt_edit./2];
		end
		BandCallbackStr=['GetFrequInterval(''setBand0',int2str(BandInd),''')'];
		
		hBandMenu(BandInd) = uicontrol( ...
		'Style','push', ...
		'Units','normalized', ...
		'Position',btnPos, ...
		'Value',0,...
		'callback',BandCallbackStr,...
		'Enable','on');
		
		if min(Vec)>DefMat(BandInd,2) | max(Vec)<DefMat(BandInd,1)
			set(hBandMenu(BandInd),'Enable','off')
		elseif min(Vec)>DefMat(BandInd,1) & max(Vec)>=DefMat(BandInd,2)
			DefMat(BandInd,3)=min(Vec);
		elseif min(Vec)<DefMat(BandInd,1) & max(Vec)<=DefMat(BandInd,2)
			DefMat(BandInd,4)=max(Vec);
		elseif min(Vec)>DefMat(BandInd,1) & max(Vec)<DefMat(BandInd,2)
			DefMat(BandInd,3)=min(Vec);
			DefMat(BandInd,4)=max(Vec);
		end
		Str=[deblank(DefStrMat(BandInd,:)),' ',num2str(round(DefMat(BandInd,3).*10)./10),'-',num2str(round(DefMat(BandInd,4).*10)./10),' Hz'];
		set(hBandMenu(BandInd),'String',Str);
	end
	
	hVec=uicontrol('Visible','off','Userdata',Vec);
	hDefMat=uicontrol('Visible','off','Userdata',DefMat);
	hDefStrMat=uicontrol('Visible','off','Userdata',DefStrMat);
	NonUse=0;
	
	hList=[hVec hMinPointText hMinPointMenu hMinPointSlider hMaxPointText ...
			hMaxPointMenu hMaxPointSlider hDefMat hDefStrMat hBandMenu];
			
	set(hGetFrequIntervalMenuFig,'Visible','on','UserData',hList);
	
elseif strcmp(action,'setMinPoint') | strcmp(action,'setMinPointSlider') 

	hList=get(hGetFrequIntervalMenuFig,'Userdata'); 
	Vec=get(hList(1),'Userdata');
	NPoints=length(Vec);
	MinPointText = get(hList(2),'String');
	MinPoint = get(hList(3),'Value');
	MinPointString = get(hList(3),'String');
	MinPointSlider = get(hList(4),'Value');
	MaxPoint = get(hList(6),'Value');
	MaxPointString = get(hList(6),'String');
	MaxPointSlider = get(hList(7),'Value');
	if ~strcmp(action,'setMinPointSlider')
		ind = find(abs(MinPointString)<32);
		MinPointString(ind) = 32*ones(size(ind));
		MinPointString = MinPointString';	
		MinPointTmp = eval(['[' MinPointString(:)' ']'],'-1')';
		[NonUse,MinPointTmp]=min(abs(Vec-MinPointTmp));
	else
		MinPointTmp = round(MinPointSlider);
	end
	if length(MinPointTmp)~=1; 
		MinPointTmp = MinPoint; 
	end
    if MinPointTmp>NPoints; 
		MinPointTmp=NPoints; 
	end
	if MinPointTmp<=0; 
		MinPointTmp=1; 
	end
	MinF=round(Vec(MinPointTmp).*100)./100;
	set(hList(3),'Value',MinPointTmp,'String',num2str(MinF));	
	set(hList(4),'Value',MinPointTmp);
	Ind=findstr(MinPointText,'#');
	if ~isempty(Ind)
		MinPointText=[MinPointText(1:Ind),' ',int2str(MinPointTmp)];
	else
		MinPointText=[MinPointText,'; # ',int2str(MinPointTmp)];
	end
	set(hList(2),'String',MinPointText);
	if MinPointTmp>MaxPoint; 
        set(hList(7),'Value',MinPointTmp); %MaxPointSlider
        GetFrequInterval('setMaxPointSlider');
    end
	if MinPointTmp~=MinPoint & any(strcmp(who('global'),'hPlot2dMenuFig'))
		Plot2d('SetFrequInterval')
		global hGetFrequIntervalMenuFig
	end
	figure(hGetFrequIntervalMenuFig);
		
elseif strcmp(action,'setMaxPoint') | strcmp(action,'setMaxPointSlider') 

	hList=get(hGetFrequIntervalMenuFig,'Userdata'); 
	Vec=get(hList(1),'Userdata');
	NPoints=length(Vec);
	MinPointText = get(hList(2),'String');
	MinPoint = get(hList(3),'Value');
	MinPointString = get(hList(3),'String');
	MinPointSlider = get(hList(4),'Value');
	MaxPointText = get(hList(5),'String');
	MaxPoint = get(hList(6),'Value');
	MaxPointString = get(hList(6),'String');
	MaxPointSlider = get(hList(7),'Value');
	if ~strcmp(action,'setMaxPointSlider');
		ind=find(abs(MaxPointString)<32);
		MaxPointString(ind)=32*ones(size(ind));
		MaxPointString=MaxPointString';	
		MaxPointTmp=eval(['[' MaxPointString(:)' ']'],'-1')';
		[NonUse,MinPointTmp]=min(abs(Vec-MaxPointTmp));
	else
		MaxPointTmp=round(MaxPointSlider);
	end
	if length(MaxPointTmp)~=1; 
		MaxPointTmp=MaxPoint; 
	end
    if MaxPointTmp>=NPoints; 
		MaxPointTmp=NPoints; 
	end
	if MaxPointTmp<1; 
		MaxPointTmp=1; 
	end
	MaxF=round(Vec(MaxPointTmp).*100)./100;
	set(hList(6),'Value',MaxPointTmp,'String',num2str(MaxF));	
	set(hList(7),'Value',MaxPointTmp);
	Ind=findstr(MaxPointText,'#');
	if ~isempty(Ind)
		MaxPointText=[MaxPointText(1:Ind),' ',int2str(MaxPointTmp)];
	else
		MaxPointText=[MaxPointText,'; # ',int2str(MaxPointTmp)];
	end
	set(hList(5),'String',MaxPointText);
	if MaxPointTmp<MinPoint;
        set(hList(4),'Value',MaxPointTmp); %MinPointSlider
        GetFrequInterval('setMinPointSlider')
    end
	if MaxPointTmp~=MaxPoint & any(strcmp(who('global'),'hPlot2dMenuFig'))
		Plot2d('SetFrequInterval')
	end
	figure(hGetFrequIntervalMenuFig);
	
elseif ~isempty(findstr(action,'setBand'))
		
	hList=get(hGetFrequIntervalMenuFig,'Userdata'); 
	Vec=get(hList(1),'Userdata');
	BandInd=str2num(action(8:9));
	DefMat=get(hList(8),'Userdata');
	[NonUse,MinPointTmp]=min(abs(Vec-DefMat(BandInd,3)));
	set(hList(4),'Value',MinPointTmp); 		%MinPointSlider
	GetFrequInterval('setMinPointSlider');
	[NonUse,MaxPointTmp]=min(abs(Vec-DefMat(BandInd,4)));
	set(hList(7),'Value',MaxPointTmp); 		%MaxPointSlider
	GetFrequInterval('setMaxPointSlider');
		
end
