function[Val]=IfEmptyInputValInt(string1,string2,In,Default,MinInt,MaxInt,ClearStatus);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if nargin<7; ClearStatus=0; end;
if nargin<6; MaxInt=[]; end;
if nargin<5; MinInt=[]; end;
if nargin<4; Default=[]; end;
if nargin<3; In=[]; end;

if ClearStatus;fprintf('\n');clc;end

if ~isempty(Default)
	if isempty(MinInt) & ~isempty(MaxInt) & Default>MaxInt
		fprintf('Bad Default in IfEmptyInputValInt !!\n\n'); Default=[];
	elseif ~isempty(MinInt) & isempty(MaxInt)  & Default<MinInt
		fprintf('Bad Default in IfEmptyInputValInt !!\n\n'); Default=[];
	elseif ~isempty(MinInt) & ~isempty(MaxInt) & (Default<MinInt | Default>MaxInt)
		fprintf('Bad Default in IfEmptyInputValInt !!\n\n'); Default=[];
	end
end
if isempty(In)
	
	if ~isempty(string1); fprintf(string1); fprintf('\n'); end
	if ~isempty(string2); fprintf(string2); fprintf('\n'); end

	if isempty(MinInt) & ~isempty(MaxInt)
		fprintf(1,'Please insert a value <= %g :\n\n',MaxInt);
	elseif ~isempty(MinInt) & isempty(MaxInt)
		fprintf(1,'Please insert a value >= %g :\n\n',MinInt);
	elseif ~isempty(MinInt) & ~isempty(MaxInt)
		fprintf(1,'Please insert a value between %g and %g :\n\n',MinInt,MaxInt);
	end
	if ~isempty(Default)
		fprintf(1,'(The default value is [%g] !)',Default)
	end
	again=1;
	while again
		Val = input(' ');
		if isempty(Val)
			if ~isempty(Default)
				Val=Default;
			else
				fprintf('Sorry ! This input is not permitted !');
			end
		end
		if ~isempty(Val)
			if isempty(MinInt) & ~isempty(MaxInt)
				if Val>MaxInt 
					fprintf('Sorry ! The value is bigger than the maximum allowed value %g !',MaxInt);
				else
					again=0;
				end
			elseif ~isempty(MinInt) & isempty(MaxInt)
				if Val<MinInt 
					fprintf('Sorry ! The value is smaller than the minimum allowed value %g !',MinInt);
				else
					again=0;
				end
			elseif ~isempty(MinInt) & ~isempty(MaxInt)
				if Val>MaxInt 
					fprintf('Sorry ! The value is bigger than the maximum allowed value %g !',MaxInt);
				elseif Val<MinInt 
					fprintf('Sorry ! The value is smaller than the minimum allowed value %g !',MinInt);
				else
					again=0;
				end
			elseif isempty(MinInt) & isempty(MaxInt)
				again=0;
			end
		end
	end
	clc;
	return;
else
	Val=In;
	clc;
	return;
end
