%==================================================================
%
%	MinMaxInfo.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
	
	function[MinMat,MaxMat]=MinMaxInfo(Mat,title_num,CH_MINMAXMATINFO,string1,string2);


%
%
%=================================================================
if nargin<5; string2=[]; end
if nargin<4; string1=[]; end
if nargin<3; CH_MINMAXMATINFO=[]; end
if nargin<2; title_num=[]; end
if nargin<1; Mat=[]; return; end
if isempty(Mat); return; end
if isempty(CH_MINMAXMATINFO); global CH_MINMAXMATINFO; end
fprintf('\n');clc;
[CH_MINMAXMATINFO]=IfEmptyInputBo(['Do you want to get information'],[' about the extrema of this matrix ?'],CH_MINMAXMATINFO,1);	
if ~CH_MINMAXMATINFO; return; end;

fprintf('\n');clc;

if ~isempty(title_num)
	[title_string]=title_string_func(title_num,1);
	fprintf(title_string); fprintf('\n\n\n')
end
 if ~isempty(string1)
	fprintf(string1); fprintf('\n\n\n')
end
if ~isempty(string2)
	fprintf(string2); fprintf('\n\n\n')
end
MinMat=min(min(Mat));
MaxMat=max(max(Mat));
fprintf(1,'The minimum value of this matrix is %g  !\n\n',MinMat);
fprintf(1,'The maximum value of this matrix is %g  !\n\n',MaxMat);
pause

return;
