%==================================================================
%
%	ReadEConfig.m
%
%	Markus Junghoefer	[1996]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	
%	Function definition

function[NChan,SpherRadius,EPosSpher,ENames,EConfigFile,EConfigPath,EConfigFilePath]=ReadEConfig(EConfigFilePath)
	
%=================================================================
if nargin<1; EConfigFilePath=[]; end;

[EConfigFile,EConfigPath,EConfigFilePath]=ReadFilePath(EConfigFilePath,'*.ecfg','Choose a SCADS .ecfg file:');
if EConfigFile==0; return; end;
fid=fopen(EConfigFilePath,'r','b');
if fid < 3
	fprintf('Cant find the file:\n') 
	fprintf(EConfigFilePath);
	fprintf('\n');
	[ch_TakeOrCancel]=IfEmptyInputSpecVal([],[1 2],1,...
					  	['Do you want to choose a different file         [1]'],...
						['or do you want to cancel ?                     [2]']);
	if ch_TakeOrCancel==1
		[EConfigFile,EConfigPath,EConfigFilePath]=ReadFilePath([]);
	end
	if isempty(EConfigFilePath) | ch_TakeOrCancel==2
		EPosSpher=[]; EPosCart=[]; return; 
	else
		fid=fopen(EConfigFilePath,'r','b');
	end
end
if	fid > 2
	fprintf('Start reading electrode configuration from file:\n\n');
	disp(EConfigFilePath);
	fprintf('\n');
	[NChan,count] = fread(fid,1,'int16');
	[SpherRadius,count] = fread(fid,1,'float32');
	[EPosSpher,count]= fread(fid,[NChan,2],'float32');
	[ENames,count]= fread(fid,[NChan,6],'uchar');
	ENames=setstr(ENames);
	fprintf('End reading electrode configuration.\n\n');
	fclose(fid);
end
return;
