function[NFiles,FileMatNew,VersionString,BatchFilePath]=ReadFileNames(FileMat,filterSpec,dialogTitle,x,y,PrintStatus,ChFilterSpecPathStatus,MaxNFiles);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	ReadFileNames.m
%
%	Markus Junghoefer	[1996]
%
%
%	Function definition
%
% 	
% 	function[NFiles,FileMatNew,VersionString,BatchFilePath]=ReadFileNames(FileMat,FileExt,dialogTitle,x,y,PrintStatus,ChFilterSpecPathStatus,MaxNFiles);
% 
%
%
%=================================================================
if nargin<8; MaxNFiles=inf; end
if nargin<7; ChFilterSpecPathStatus=1; end
if nargin<6; PrintStatus=1; end
if nargin<5; y=0; end
if nargin<4; x=0; end
if nargin<3; dialogTitle=[]; end
if nargin<2; filterSpec=[]; end
if nargin<1; FileMat=[]; end

if isempty(MaxNFiles); MaxNFiles=inf; end
VersionString=version;
if ~isempty(FileMat); 
    FileMatNew=FileMat;
    NFiles=size(FileMat,1);
    [NonUse,NonUse,BatchFilePath]=GetFileNameOfMat(FileMat,1);
    return; 
end
if isempty(x); x=0; end
if isempty(y); y=0; end
if isempty(PrintStatus); PrintStatus=1; end

OneMoreFile=1;
FileIndex=0;
SepPathStr=filesep;
ExistStatusTmp=[];
if isempty(filterSpec)
    filterSpec=SetDefPath(1,'*');
end
while OneMoreFile & FileIndex<MaxNFiles
    FileIndex=FileIndex+1;
    if FileIndex==1
        if PrintStatus; fprintf('\n\n'); fprintf(1,'Please choose a first data file or a batch file (use e.g. Dir2Batch):\n\n\n'); end
        if isempty(dialogTitle); 
            if MaxNFiles>1
                dialogTitleTmp=['Please choose a first data file or a batch file (use e.g. Dir2Batch):']; 
            else
                dialogTitleTmp=['Please choose a data file:']; 
            end
        else; 
            dialogTitleTmp=dialogTitle;
        end
        [File,Path]=uigetfile(filterSpec,dialogTitleTmp,x,y)
        if FileIndex==1 & File==0
            NFiles=0;
            FileMatNew=[];
            BatchFilePath=[];
            return; 
        end
        BatchFilePath=[Path,File];
        SetDefPath(2,Path);
        if MaxNFiles>1
            fid=fopen(BatchFilePath,'r','b');
            NFiles=0;
            ExistStatus=1;
            while feof(fid)==0 & ExistStatus~=0;
                NFiles=NFiles+1;
                ExistStatus=1;
                FilePath=deblank(fgetl(fid));
                TestFid=fopen(FilePath,'r','b');
                if TestFid==-1
                    ExistStatus=0;
                else
                    fclose(TestFid);
                    disp(FilePath)
                end	
                if ExistStatus==0 & NFiles==1 & PrintStatus
                    clc;
                    fprintf(1,'The file:\n\n')
                    disp(FilePath); fprintf(1,'\n\n');
                    fprintf(1,'does not exist or can\n\n')
                    fprintf(1,'not be opened for reading.\n\n')
                    fprintf(1,'The file\n\n')
                    fprintf(1,BatchFilePath); fprintf(1,'\n\n');
                    fprintf(1,'seems not to be batch file !\n\n')
                end
                if ExistStatus==0 & NFiles>1 & PrintStatus
                    fprintf(1,'The file\n\n')
                    disp(FilePath); fprintf(1,'\n\n');
                    fprintf(1,'does not exist or can\n\n')
                    fprintf(1,'not be opened for reading.\n\n')
                    Message=char(['The file in batch line ',int2str(NFiles)])
                    Message=char(Message,'')
                    Message=char(Message,FilePath)
                    Message=char(Message,'')
                    Message=char(Message,'does not exist or can not be opened for reading.')
                    Message=char(Message,'')
                    ButtonName=questdlg(Message,'','Ignore','Cancel','Ignore');  
                    %uiwait
                    switch ButtonName,
                        case 'Ignore', 
                            disp(['Ignore file: ',FilePath,' and continue ...']);
                            NFiles=NFiles-1;
                        case 'Cancel',
                            disp('Cancel and Return')
                            NFiles=0; FileMatNew=[]; BatchFilePath=[];
                            return;
                    end % switch
                end
                if ExistStatus
                    if NFiles==1
                        FileMatNew=char(FilePath);
                    else
                        FileMatNew=char(FileMatNew,FilePath);
                    end
                end
                if NFiles>1 & ~ExistStatus
                    ExistStatus=1;
                end
            end
        else
            ExistStatus=1;
            NFiles=1;
            FilePath=BatchFilePath;
            FileMatNew=char(FilePath);
        end		
        if ExistStatus~=0 & PrintStatus
            fprintf('\n\n'); clc; 
            disp(FileMatNew)
            return;
        end
    else
        if PrintStatus; fprintf('\n\n'); fprintf(1,'Please choose the %g  file or press "Cancel" to be done: ',FileIndex); end
        if isempty(dialogTitle); 
            dialogTitleTmp=['Choose the ',int2str(FileIndex),' file or press "Cancel" to be done:']; 
        else; 
            dialogTitleTmp=dialogTitle;
        end
        [File,Path]=uigetfile(filterSpec,dialogTitleTmp,x,y);
    end		
    if ChFilterSpecPathStatus & File~=0;
        SepStrVec=findstr(filterSpec,SepPathStr);
        if ~isempty(SepStrVec)
            filterSpec=[Path,filterSpec(SepStrVec(length(SepStrVec))+1:length(filterSpec))];
        else
            filterSpec=[Path,filterSpec];
        end	
    end		
    if File==0
        OneMoreFile=0;
        NFiles=FileIndex-1;
    else
        FilePath=[Path,File];
        if FileIndex==1
            FileMatNew=char(FilePath);
        else
            FileMatNew=char(FileMatNew,FilePath);
        end
    end
    if PrintStatus; 
        fprintf('\n\n'); clc; 
        disp(FileMatNew);
    end
end
if NFiles==0; FileMatNew=[]; end
NFiles=size(FileMatNew,1);
return;
