%==================================================================
%
%	ReadKNAvgFile.m
%
%	Markus Junghoefer	[1996]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
%
	function[AvgMat,File,Path,FilePath,NTrialAvgVec,...
	StdChanTimeMat,SampRate,AvgRef]=...
	ReadKNAvgFile(FilePath,Version)
%
%==================================================================
if nargin<2; Version=1; end;
if nargin<1; FilePath=[]; end;

[File,Path,FilePath]=ReadFilePath(FilePath,'*.at*',['Averaged file:'],[],[],['Please choose the\n'],['averaged file to analyse:']);
if strcmp(FilePath(length(FilePath)-2:length(FilePath)),'.ar'); AvgRef=1; else; AvgRef=0; end
	
fprintf('\n')
clc;
fprintf('Start reading data file...\n\n');
fprintf(FilePath);
fprintf('\n\n');

fid=fopen(FilePath,'r');
[SizeAvgMat,count]=fread(fid,2,'int16');
NChan=SizeAvgMat(1);
NPoints=SizeAvgMat(2);
AvgMat=fread(fid,SizeAvgMat','float32');
[SizeNTrialAvgVec,count]=fread(fid,2,'int16');
NTrialAvgVec=fread(fid,SizeNTrialAvgVec','float32');
[SizeStdChanTimeMat,count]=fread(fid,2,'int16');
StdChanTimeMat=fread(fid,SizeStdChanTimeMat','float32');
[SizeSampRate,count]=fread(fid,2,'int16');
SampRate=fread(fid,SizeSampRate','float32');

fprintf('End reading data file...\n');

fclose(fid);
return;
