function[SetFilePath,ParaVec,MEGSensorPosMat,EEGSensorPosMat,
        MEGSensorNameVec,EEGSensorNameVec,MEGSensorIndexVec,
        EEGSensorIndexVec,MsiFormat,MSIChannelOrderVec,
        MsiPatient,MsiScan,MsiSession,MsiRun,
        ExternSensorNameVec,ExternSensorIndexVec]=ReadMsiSet(SetFilePath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	ReadMsiSet.m
%
%	Markus Junghoefer	[2000]
%
%
%	
%	Function definition	
%=================================================================
if nargin<1; SetFilePath=[];end

ParaVec=[];
MEGSensorPosMat=[];
EEGSensorPosMat=[];
MEGSensorNameVec=[];
EEGSensorNameVec=[];
MEGSensorIndexVec=[];
EEGSensorIndexVec=[];
ExternSensorNameVec=[];
ExternSensorIndexVec=[];
File=[];
Path=[];
String='Choose MSI set file:';
[DefPath]=SetDefPath(1,'*.set');
[SetFile,SetPath,SetFilePath]=ReadFilePath(SetFilePath,DefPath,String);
SetDefPath(2,SetPath);
if SetFile==0; MsiFilePath=[]; return; end
if exist(SetFilePath,'file')~=2
	Message=char('Sorry,');
	Message=char(Message,'unable to find MSI set file:');
	Message=char(Message,'');
	Message=char(Message,[SetFilePath]);
	Message=char(Message,'');
	hmsgbox=msgbox(Message,'Info','help'); 
	return;
end
fprintf(1,'Read msi set from file:\n')
fprintf(1,SetFilePath)
KeyWordMat=char('MSI.TotalChannels:');
KeyWordMat=char(KeyWordMat,'MSI.TotalSlices:');
KeyWordMat=char(KeyWordMat,'MSI.TotalEpochs:');
KeyWordMat=char(KeyWordMat,'MSI.SigAChanCount:');
KeyWordMat=char(KeyWordMat,'MSI.EEGChanCount:');
KeyWordMat=char(KeyWordMat,'MSI.SampleFrequency:');
KeyWordMat=char(KeyWordMat,'MSI.SamplePeriod:');
KeyWordMat=char(KeyWordMat,'MSI.FirstLatency:');
KeyWordMat=char(KeyWordMat,'MSI.ExternChanCount:');
KeyWordFormat=['d','d','d','d','f','f','f','d','d'];
NKeyWord=size(KeyWordMat,1);
ParaVec=zeros(11,1);
ParaVecTmp=zeros(NKeyWord,1);
SetFid=fopen(SetFilePath,'rt');
while feof(SetFid) == 0
   	Line=fgetl(SetFid);
	for KeyWordInd=1:NKeyWord
		Keyword=deblank(KeyWordMat(KeyWordInd,:));
		Matches=findstr(Line,Keyword);
		TestLine=sprintf(['%s\t%%',KeyWordFormat(KeyWordInd)],Keyword);
		Num=length(Matches);
		if Num>0
	    	ParaVecTmp(KeyWordInd)=sscanf(Line,TestLine,1);
		end
	end
end
frewind(SetFid);
NTotChan=ParaVecTmp(1);     ParaVec(1)=ParaVecTmp(1);
NPoints=ParaVecTmp(2);      ParaVec(2)=ParaVecTmp(2);
NTrials=ParaVecTmp(3);      ParaVec(3)=ParaVecTmp(3);
NMegChan=ParaVecTmp(4);     ParaVec(4)=ParaVecTmp(4);
NEegChan=ParaVecTmp(5);     ParaVec(5)=ParaVecTmp(5);
SampRate=ParaVecTmp(6);     ParaVec(6)=ParaVecTmp(6);
SampPeriod=ParaVecTmp(7);   ParaVec(7)=ParaVecTmp(7);
BaseMs=ParaVecTmp(8);       ParaVec(8)=ParaVecTmp(8);
%Duration
%NBit
NExternChan=ParaVecTmp(9); ParaVec(11)=ParaVecTmp(9);
%================Read MSI Format
Keyword='MSI.Format:';
while feof(SetFid) == 0
   	Line=fgetl(SetFid);
	Matches=findstr(Line,Keyword);
	TestLine=sprintf(['%s\t%%','s'],Keyword);
	Num=length(Matches);
	if Num>0
	    MsiFormat=sscanf(Line,TestLine,1);
	end
end
MsiFormat=lower(MsiFormat);
frewind(SetFid);
if strcmp(MsiFormat,'float') | strcmp(MsiFormat,'float32')
    NBit=4;
elseif strcmp(MsiFormat,'int16') | strcmp(MsiFormat,'short')
    NBit=2;
end
ParaVec(10)=NBit;
%================Read MSI Patient
Keyword='MSI.Patient:';
while feof(SetFid) == 0
   	Line=fgetl(SetFid);
	Matches=findstr(Line,Keyword);
	TestLine=sprintf(['%s\t%%','s'],Keyword);
	Num=length(Matches);
	if Num>0
	    MsiPatient=sscanf(Line,TestLine,1);
	end
end
frewind(SetFid);
%================Read MSI Scan
Keyword='MSI.Scan:';
while feof(SetFid) == 0
   	Line=fgetl(SetFid);
	Matches=findstr(Line,Keyword);
	TestLine=sprintf(['%s\t%%','s'],Keyword);
	Num=length(Matches);
	if Num>0
	    MsiScan=sscanf(Line,TestLine,1);
	end
end
frewind(SetFid);
%================Read MSI Session
Keyword='MSI.Session:';
while feof(SetFid) == 0
   	Line=fgetl(SetFid);
	Matches=findstr(Line,Keyword);
	Num=length(Matches);
	if Num>0
        Tmp=findstr(Line,':');
        Tmp=Tmp(2);
	    MsiSession=[Line(Tmp-11:Tmp-4),'@',Line(Tmp-2:Tmp+2)];
	end
end
frewind(SetFid);
%================Read MSI Run
Keyword='MSI.Run:';
while feof(SetFid) == 0
   	Line=fgetl(SetFid);
	Matches=findstr(Line,Keyword);
	TestLine=sprintf(['%s\t%%','d'],Keyword);
	Num=length(Matches);
	if Num>0
	    MsiRun=sscanf(Line,TestLine,1);
	end
end
frewind(SetFid);
%================Read MEG SensorIndexVec
frewind(SetFid);
KeyWord='MSI.SigAChanIndex:';
MEGSensorIndexVec=zeros(NMegChan,1);
while feof(SetFid) == 0
   	Line=fgetl(SetFid);
	Matches=findstr(Line,KeyWord);
	Num=length(Matches);
	if Num>0
		Index=1;
		%================eat up IndexLine
	   	Remainder=Line(Matches(1)+length(KeyWord):length(Line));
	   	while(any(Remainder));
			[Chopped,Remainder]=strtok(Remainder,',');
			Tmp=sscanf(Chopped,'%d');
			MEGSensorIndexVec(Index)=Tmp+1;% Index=0 is first sensor
			Index=Index+1;
	    end
	end
end
%================Read MEG MEGSensorNameVec
frewind(SetFid);
KeyWord='MSI.SigAChanNames:';
MEGSensorNameVec=[];
while feof(SetFid) == 0
   	Line=fgetl(SetFid);
	Matches=findstr(Line,KeyWord);
	Num=length(Matches);
	if Num>0
		Index=1;
		%================eat up IndexLine
	   	Remainder=Line(Matches(1)+length(KeyWord):length(Line));
	   	while(any(Remainder));
			[Chopped,Remainder]=strtok(Remainder,',');
            if isempty(MEGSensorNameVec)
			    MEGSensorNameVec=char(Chopped);
            else			    
                MEGSensorNameVec=char(MEGSensorNameVec,Chopped);
            end    
			Index=Index+1;
	    end
	end
end
%================Read EEG SensorIndexVec
frewind(SetFid);
KeyWord='MSI.EEGChanIndex:';
EEGSensorIndexVec=zeros(NEegChan,1);
while feof(SetFid) == 0
   	Line=fgetl(SetFid);
	Matches=findstr(Line,KeyWord);
	Num=length(Matches);
	if Num>0
		Index=1;
		%================eat up IndexLine
	   	Remainder=Line(Matches(1)+length(KeyWord):length(Line));
	   	while(any(Remainder));
			[Chopped,Remainder]=strtok(Remainder,',');
			Tmp=sscanf(Chopped,'%d');
			EEGSensorIndexVec(Index)=Tmp+1; % Index of zero is first sensor
			Index=Index+1;
	    end
	end
end
%================Read EEGSensorNameVec
frewind(SetFid);
KeyWord='MSI.EEGChanNames:';
EEGSensorNameVec=[];
while feof(SetFid) == 0
   	Line=fgetl(SetFid);
	Matches=findstr(Line,KeyWord);
	Num=length(Matches);
	if Num>0
		Index=1;
		%================eat up IndexLine
	   	Remainder=Line(Matches(1)+length(KeyWord):length(Line));
	   	while(any(Remainder));
			[Chopped,Remainder]=strtok(Remainder,',');
            if isempty(EEGSensorNameVec)
			    EEGSensorNameVec=char(Chopped);
            else  
                EEGSensorNameVec=char(EEGSensorNameVec,Chopped);   
            end
			Index=Index+1;
	    end
	end
end
if NExternChan>0
    %================Read ExternSensorIndexVec
    frewind(SetFid);
    KeyWord='MSI.ExternChanIndex:';
    ExternSensorIndexVec=zeros(NExternChan,1);
    while feof(SetFid) == 0
    	Line=fgetl(SetFid);
    	Matches=findstr(Line,KeyWord);
    	Num=length(Matches);
    	if Num>0
	    	Index=1;
    		%================eat up IndexLine
	        Remainder=Line(Matches(1)+length(KeyWord):length(Line));
	    	while(any(Remainder));
			    [Chopped,Remainder]=strtok(Remainder,',');
			    Tmp=sscanf(Chopped,'%d');
			    ExternSensorIndexVec(Index)=Tmp+1; % Index of zero is first sensor
			    Index=Index+1;
	        end
	    end
    end
    %================Read ExternSensorNameVec
    frewind(SetFid);
    KeyWord='MSI.ExternChanNames:';
    ExternSensorNameVec=[];
    while feof(SetFid) == 0
   	    Line=fgetl(SetFid);
	    Matches=findstr(Line,KeyWord);
	    Num=length(Matches);
	    if Num>0
	    	Index=1;
	    	%================eat up IndexLine
	     	Remainder=Line(Matches(1)+length(KeyWord):length(Line));
	     	while(any(Remainder));
		    	[Chopped,Remainder]=strtok(Remainder,',');
                if isempty(ExternSensorNameVec)
			        ExternSensorNameVec=char(Chopped);
                else  
                   ExternSensorNameVec=char(ExternSensorNameVec,Chopped);   
                end
			    Index=Index+1;
	        end
	    end
    end
end
%================Read MSI Channel Order
frewind(SetFid);
KeyWord='MSI.ChannelOrder:';
MSIChannelOrderVec=[];
while feof(SetFid) == 0
   	Line=fgetl(SetFid);
	Matches=findstr(Line,KeyWord);
	Num=length(Matches);
	if Num>0
		Index=1;
		%================eat up IndexLine
	   	Remainder=Line(Matches(1)+length(KeyWord):length(Line));
	   	while(any(Remainder));
			[Chopped,Remainder]=strtok(Remainder,',');
            if isempty(MSIChannelOrderVec)
			    MSIChannelOrderVec=char(Chopped);
            else
                MSIChannelOrderVec=char(MSIChannelOrderVec,Chopped);
            end
			Index=Index+1;
	    end
	end
end
%================Read MEG Sensor Position and Orientation Matrix
frewind(SetFid);
KeyWord='MSI.Position_Information.Begin:';
MEGSensorNameVec=[];
MEGSensorPosMat=zeros(NMegChan,6);
while feof(SetFid) == 0
   	Line=fgetl(SetFid);
	Matches=findstr(Line,KeyWord);
	Num=length(Matches);
	if Num>0
		for ChanInd=1:NMegChan
			Line=fgetl(SetFid);
			SpaceVec=isspace(Line);
			LineTmp=[];
			for i=1:length(SpaceVec)
				if ~SpaceVec(i)
					LineTmp=char(LineTmp,Line(i));
				else
					if ~SpaceVec(i-1)
						LineTmp=char(LineTmp,' ');
					end
				end
			end
			LineTmp=deblank(LineTmp');
			[Chopped,Remainder]=strtok(LineTmp,' ');
			MEGSensorNameVec=char(MEGSensorNameVec,Chopped);
			Index=1;
			% eat up IndexLine
	   		while(any(Remainder));
				[Chopped,Remainder]=strtok(Remainder,' ');
				Tmp=sscanf(Chopped,'%f');
				MEGSensorPosMat(ChanInd,Index)=Tmp;
				Index=Index+1;
			end
	    end
	end
end
fclose(SetFid);
Duration=SampPeriod.*NPoints;
ParaVec(9)=Duration;
fprintf(1,'\n\n\n');
fprintf(1,'Total number of sensors: %g\n', 	NTotChan);
fprintf(1,'Number of points:        %g\n',  NPoints);
fprintf(1,'Number of trials:        %g\n',  NTrials);
fprintf(1,'Number of MEG sensors:   %g\n', 	NMegChan);
fprintf(1,'Number of EEG sensors:   %g\n', 	NEegChan);
fprintf(1,'Number of extern sensors:%g\n', 	NExternChan);
fprintf(1,'Sampling Rate [Hz]:      %g\n',  SampRate);
fprintf(1,'Sampling Period [ms]:    %g\n',  SampPeriod);
fprintf(1,'First Latency [ms]:      %g\n',  BaseMs);
fprintf(1,'Duration [ms]:           %g\n',  Duration);
fprintf(1,['File format:             ',  MsiFormat]);   fprintf(1,'\n');
fprintf(1,['Patient:                 ',  MsiPatient]);  fprintf(1,'\n');
fprintf(1,['Scan:                    ',  MsiScan]);     fprintf(1,'\n');
fprintf(1,['Session:                 ',  MsiSession]);  fprintf(1,'\n');
fprintf(1,['Run:                     ',  MsiRun]);      fprintf(1,'\n\n');
return;
