%==================================================================
%
%	ReadOrCalcPCoeff.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	
%	Function definition

	function [Coeff] = ReadOrCalcPCoeff(status,A,B,path_leg,...
					   PathCoeff, ECFGFILE,...
					   NScalp, PIter, mSpherical, LengthLegVec)

	
%=================================================================
size_A=size(A);
size_B=size(B);
if strcmp(computer,'MAC2')	
   SepPathStr=':';
elseif strcmp(computer,'PCWIN')
   SepPathStr='\';
elseif strcmp(computer,'SOL2')
    SepPathStr='/';      
end;

if ECFGFILE(length(ECFGFILE)-4:length(ECFGFILE))=='.ecfg'
	Ecfg=ECFGFILE(1:length(ECFGFILE)-5);
else
	Ecfg=ECFGFILE;
end
if status==1
	[CosPhiMat]=ExistCalcPhiMat(-1,A, B, PathCoeff, Ecfg);
	CoeffFile = [PathCoeff,SepPathStr,'PInv_',Ecfg,'_',num2str(NScalp),'_',num2str(PIter),'_',num2str(mSpherical)];
elseif status==2
	[CosPhiMat]=ExistCalcPhiMat(1,A, B, PathCoeff, Ecfg);
	CoeffFile = [PathCoeff,SepPathStr,'PScalp_',Ecfg,'_',num2str(NScalp),'_',num2str(PIter),'_',num2str(mSpherical)];
elseif status==3
	[CosPhiMat]=ExistCalcPhiMat(1,A, B, PathCoeff, Ecfg);
	CoeffFile = [PathCoeff,SepPathStr,'PCsdScalp_',Ecfg,'_',num2str(NScalp),'_',num2str(PIter),'_',num2str(mSpherical)];
end
CoeffFid=fopen(CoeffFile,'r','b');
clc;
if CoeffFid<0 
	fprintf('\n\n')
	fprintf('Calculate:\n')	
	PrintFilePath(CoeffFile)
	fprintf('\n')
	Message=char(['Calculate leadfield coefficients']);
	Message=char(Message,'and save them to file:');			
	Message=char(Message,CoeffFile);
	Message=char(Message,' ');
	Message=char(Message,'This calculation could');
	Message=char(Message,'take a few seconds. ');
	hmsgbox=msgbox(Message,'Info:','help');
	hChildMsgbox=get(hmsgbox,'Children');
	set(hChildMsgbox(3),'Visible','off');
	pause(.1);
	if status==1 | status==2
		PLegFile = [path_leg,SepPathStr,'PLeg_',num2str(PIter),'_',num2str(mSpherical),'_',num2str(LengthLegVec)];
		PLegFid=fopen(PLegFile,'r','b');
		[PLegVec] =fread(PLegFid,inf,'float64');
		fclose(PLegFid);
		[Coeff] = CalcCoeff(CosPhiMat,PLegVec,LengthLegVec);
		CoeffFid=fopen(CoeffFile,'w','b');
		fwrite(CoeffFid,Coeff,'float32');
		fclose(CoeffFid);
		close(hmsgbox);
		return;
	elseif status==3
		CsdPLegFile = [path_leg,SepPathStr,'CsdPLeg_',num2str(PIter),'_',num2str(mSpherical),'_',num2str(LengthLegVec)];
		CsdPLegFid=fopen(CsdPLegFile,'r','b');
		[CsdPLegVec] =fread(CsdPLegFid,inf,'float64');	
		fclose(CsdPLegFid);
		[Coeff] = CalcCoeff(CosPhiMat,CsdPLegVec,LengthLegVec);
		CoeffFid=fopen(CoeffFile,'w','b');
		fwrite(CoeffFid,Coeff,'float32');
		fclose(CoeffFid);
		close(hmsgbox);
		return;
	end
else
	fprintf('Read file:\n');
	PrintFilePath(CoeffFile);
	fprintf('\n');
	Message=char(['Read leadfield coefficients from file:']);
	Message=char(Message,CoeffFile);
	Message=char(Message,' ');
	hmsgbox=msgbox(Message,'Info:','help'); 
	hChildMsgbox=get(hmsgbox,'Children');
	set(hChildMsgbox(3),'Visible','off');
	pause(1);
	if status==1
		[Coeff,count] =fread(CoeffFid,[size_A(1),size_A(1)],'float32');
	else
		[Coeff,count] =fread(CoeffFid,[size_A(1),size_B(1)],'float32');
	end
end
close(hmsgbox);

return;
	
