%==================================================================
%
%	ReadOrCalcCoeff.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	
%	Function definition

	function [Coeff] = ReadOrCalcCoeff(status,A,B,PathLeg,...
					   PathCoeff, ECFGFILE,...
					   n_scalp, l_iter, m_iter, LengthLegVec)

	
%=================================================================

size_A=size(A);
size_B=size(B);

if strcmp(computer,'MAC2')	
   SepPathStr=':';
elseif strcmp(computer,'PCWIN')
   SepPathStr='\';
end;

if ECFGFILE(length(ECFGFILE)-4:length(ECFGFILE))=='.ecfg'
	Ecfg=ECFGFILE(1:length(ECFGFILE)-5);
else
	Ecfg=ECFGFILE;
end
if status==1
	[CosPhiMat]=ExistCalcPhiMat(-1,A, B, PathCoeff, Ecfg);
else
	[CosPhiMat]=ExistCalcPhiMat(1,A, B, PathCoeff, Ecfg);
end
if status==1
	CoeffFile = [PathCoeff,SepPathStr,'Inv_',Ecfg,'_',num2str(n_scalp),'_',num2str(l_iter)];
elseif status==2
	CoeffFile = [PathCoeff,SepPathStr,'Scalp_',Ecfg,'_',num2str(n_scalp),'_',num2str(l_iter)];
elseif status==3
	CoeffFile = [PathCoeff,SepPathStr,'CsdScalp_',Ecfg,'_',num2str(n_scalp),'_',num2str(l_iter)];
elseif status==4
	CoeffFile = [PathCoeff,SepPathStr,'Cort_',Ecfg,'_',num2str(n_scalp),'_',num2str(l_iter)];
elseif status==5
	CoeffFile = [PathCoeff,SepPathStr,'CsdCort_',Ecfg,'_',num2str(n_scalp),'_',num2str(l_iter)];
end
CoeffFid=fopen(CoeffFile,'r','b');
clc;
if CoeffFid<0 
	fprintf('\n\n')
	fprintf('Calculate:\n')	
	fprintf(CoeffFile)
	fprintf('\n')
	if status==1 | status==2
		ScalpLegFile = [PathLeg,SepPathStr,'ScalpLeg_',num2str(l_iter),'_',num2str(m_iter),'_',num2str(LengthLegVec)];
		ScalpLegFid=fopen(ScalpLegFile,'r','b');	
		[ScalpLegVec] =fread(ScalpLegFid,inf,'float64');
		fclose(ScalpLegFid);
		[Coeff] = CalcCoeff(CosPhiMat,ScalpLegVec,LengthLegVec);
		CoeffFid=fopen(CoeffFile,'w','b');
		fwrite(CoeffFid,Coeff,'float32');
		fclose(CoeffFid);
		return;
	elseif status==3
		CsdScalpLegFile = [PathLeg,SepPathStr,'CsdScalpLeg_',num2str(l_iter),'_',num2str(m_iter),'_',num2str(LengthLegVec)];
		CsdScalpLegFid=fopen(CsdScalpLegFile,'r','b');
		[CsdScalpLegVec] =fread(CsdScalpLegFid,inf,'float64');	
		fclose(CsdScalpLegFid);
		[Coeff] = CalcCoeff(CosPhiMat,CsdScalpLegVec,LengthLegVec);
		CoeffFid=fopen(CoeffFile,'w','b');
		fwrite(CoeffFid,Coeff,'float32');
		fclose(CoeffFid);
		return;
	elseif status==4
		CortLegFile = [PathLeg,SepPathStr,'CortLeg_',num2str(l_iter),'_',num2str(m_iter),'_',num2str(LengthLegVec)];
		CortLegFid=fopen(CortLegFile,'r','b');
		[CortLegVec] =fread(CortLegFid,inf,'float64');
		fclose(CortLegFid);
		[Coeff] = CalcCoeff(CosPhiMat,CortLegVec,LengthLegVec);
		CoeffFid=fopen(CoeffFile,'w','b');
		fwrite(CoeffFid,Coeff,'float32');
		fclose(CoeffFid);
		return;
	elseif status==5
		CsdCortLegFile = [PathLeg,SepPathStr,'CsdCortLeg_',num2str(l_iter),'_',num2str(m_iter),'_',num2str(LengthLegVec)];
		CsdCortLegFid=fopen(CsdCortLegFile,'r','b');
		[CsdCortLegVec] =fread(CsdCortLegFid,inf,'float64');
		fclose(CsdCortLegFid);
		[Coeff] = CalcCoeff(CosPhiMat,CsdCortLegVec,LengthLegVec);	
		CoeffFid=fopen(CoeffFile,'w','b');
		fwrite(CoeffFid,Coeff,'float32');
		fclose(CoeffFid);
		return;
	end
else
	fprintf('Read file:\n');
	fprintf(CoeffFile);
	fprintf('\n');
	if status==1
		[Coeff,count] =fread(CoeffFid,[size_A(1),size_A(1)],'float32');
	else
		[Coeff,count] =fread(CoeffFid,[size_A(1),size_B(1)],'float32');
	end
end
	
return;
	
