function [ContMat,ContStr,File,Path,FilePath,ContNameMat]=ReadRepCon(FilePath,String,DefPath,FilterSpec)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	ReadRepCon.m
%
%	Markus Junghoefer	[2003]
%
%
%	
% 	Function definition
% 
% 			  
%=================================================================
if nargin<4;FilterSpec=[];end;
if nargin<3;DefPath=[];end
if nargin<2;String=[];end
if nargin<1;FilePath=[];end
if isempty(FilterSpec); FilterSpec='*'; end

ContMat=[];
File=[];
Path=[];
if isempty(DefPath); DefPath=SetDefPath(1,FilterSpec); end
[File,Path,FilePath]=ReadFilePath(FilePath,DefPath,String);
if File==0; ContMat=[]; File=[]; Path=[]; FilePath=[]; return; end
fid=fopen(FilePath,'r','b');
LineInd=0;
ContInd=0;
ContStr=[];
MaxNWeights=0;
ContNameMat=[];
while 1
    LineInd=LineInd+1;
    tline=fgetl(fid);
    if ~ischar(tline); break; end
    disp(tline)
    if length(tline)>0
        if ~strcmp(tline(1),'%')
            ContInd=ContInd+1;
            [Name,Remainder]=strtok(tline); 
            if strcmp(Name(end),':'); Name=Name(1:end-1); end
            ContNameMat=char(ContNameMat,Name);
            [NWeightsStr,Remainder]=strtok(Remainder);
            NWeights=str2num(NWeightsStr);
            if NWeights>MaxNWeights
                ContMatNew=zeros(ContInd,NWeights+1);
                if ContInd>1
                    ContMatNew(1:ContInd-1,1:MaxNWeights+1)=ContMat;
                end
                MaxNWeights=NWeights;
            else
                ContMatNew=zeros(ContInd,MaxNWeights+1);
                if ContInd>1
                    ContMatNew(1:ContInd-1,:)=ContMat;
                end
            end
            ContMat=ContMatNew;
            ContMat(ContInd,1)=NWeights;
            WeightVec=[];
            for i=1:NWeights
                [Weight,Remainder]=strtok(Remainder); 
                WeightVec(i)=str2num(Weight);
                ContMat(ContInd,i+1)=WeightVec(i);
            end
            if sum(WeightVec)~=0
                Message=char('Attention !!!');
                Message=char(Message,'');
                Message=char(Message,'Sum of weights has to be zero.');
                Message=char(Message,'');
                Message=char(Message,['Weights of contrast ',Name,':']);
                Message=char(Message,'');
                Message=char(Message,num2str(WeightVec));
                hMsgbox=msgbox(Message,'Warning:','warn');
                uiwait;
            end
            ContStr=char(ContStr,[Name,': ',num2str(WeightVec)]);
        end 
    end
end
ContStr=ContStr(2:size(ContStr,1),:);
ContNameMat=ContNameMat(2:size(ContNameMat,1),:);
fclose(fid);
if strcmp(ContStr(length(ContStr)),'|');
    ContStr=ContStr(1:length(ContStr)-1);
end
return;
