%==================================================================
%
%	ReadTAWChan.m
%
%	Markus Junghoefer	[1997]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
%
	function[ChanVec,FilePath,Header,LHeader,Version, ...
	Year, Month, Day, Hour, Minute, Sec, MSec, ...
	SampRate, NChan, Gain, Bits, Range, NPoints, NEvents, EventCodes]= ...
	ReadTAWChan(FilePath,SpecChan);
%

%==================================================================
if nargin<2; SpecChan=1; end
if nargin<1; FilePath=[]; end
if isempty(FilePath)
	[File,Path]=uigetfile(['*.TAW'],'Choose TAW file:');
	FilePath=[Path,File];
end
fprintf('\n')
clc;
fprintf('Read header of file...\n\n');
fprintf(FilePath);
fprintf('\n\n');

fid=fopen(FilePath,'r');
Version=fread(fid,1,'long');
Year=fread(fid,1,'short');
Month=fread(fid,1,'short');
Day=fread(fid,1,'short');
Hour=fread(fid,1,'short');
Minute=fread(fid,1,'short');
Sec=fread(fid,1,'short');
MSec=fread(fid,1,'long');
SampRate=fread(fid,1,'short');
NChan=fread(fid,1,'short');
Gain=fread(fid,1,'short');
Bits=fread(fid,1,'short');
Range=fread(fid,1,'short');
NPoints=fread(fid,1,'long');
NEvents=fread(fid,1,'short');
EventCodes=fread(fid,[NEvents,4],'char');
Tell1=ftell(fid);
LHeader=Tell1;

fseek(fid,0,-1);
Header=fread(fid,LHeader,'int8');
fprintf(['Read channel #' int2str(SpecChan) '\n\n']);

SeekStatus=fseek(fid,(SpecChan-1).*NPoints.*2,0);
if SeekStatus==-1;
	fprintf('Sorry, fseek error in ReadTAWChan !')
	ChanVec=[];
end
[ChanVec,Count]=fread(fid,[1,NPoints],'int16');	
if Count~=NPoints;
	fprintf('Sorry, fread error in ReadTAWChan !')
	ChanVec=[];
	return;
end

fclose(fid);

return;
