%==================================================================
%
%	ReadTriData.m
%
%	Markus Junghoefer	[1996]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	
%	Function definition

	function[NLoc,LocVec,NTri,TriVec]=ReadTriData(FilePath)
	
%=================================================================
if nargin<1; FilePath=[]; end

if isempty(FilePath)
	[File,Path]=uigetfile('*.tri','Choose tri data file:');
	FilePath=[Path,File];
end
fid=fopen(FilePath,'r','b');
if fid==-1; fprintf('fopen fid == -1'); return; end
fprintf('Start reading of file...\n\n');
fprintf(FilePath)
fprintf('\n\n');

NLoc=fscanf(fid,'%g',1);
LocVec=zeros(NLoc,4);
for LocIndex=1:NLoc
	LocVec(LocIndex,:)=(fscanf(fid,'%g',4))';
end
LocVec=LocVec(:,2:4);

NTri=fscanf(fid,'%g',1);
TriVec=zeros(NTri,4);
for TriIndex=1:NTri
	TriVec(TriIndex,:)=(fscanf(fid,'%g',4))';
end
TriVec=TriVec(:,2:4);

fclose(fid);
fprintf('End reading of file.\n\n');

return;
