function [RotPosNormMat]=RotPmgFiles(FileMat)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<1; FileMat=[]; end


%==================================================================
DefFileMask='*.pmg';
[DefFilePath] = SetDefPath(1,DefFileMask);
[NFiles,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose .pmg files:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);

for FileIndex=1:NFiles
	[File,Path,FilePath]=GetFileNameOfMat(InFileMat,FileIndex);
	RotFilePath=[FilePath(1:length(FilePath)-3),'rot.pmg'];
	[Fid,Message]=fopen(FilePath,'r','b');
	[RotFid,Message]=fopen(RotFilePath,'w','b');
	Count1=1; SensorNChan=0;	
	while Count1~=0
		[TmpStr1,Count1]=fscanf(Fid,'%s',1);
		[TmpStr2,Count1]=fscanf(Fid,'%s',1);
		if Count1==0; break; else; SensorNChan=SensorNChan+1; end
		[Tmp1,Count1]=fscanf(Fid,'%g',6);
		Tmp2=Tmp1;
        Tmp2(1)=-1.*Tmp1(2);
		Tmp2(2)=Tmp1(1);
		Tmp2(4)=-1.*Tmp1(5);
		Tmp2(5)=Tmp1(4);
		fprintf(RotFid,'%s\t',TmpStr1);
		fprintf(RotFid,'%s\t',TmpStr2);
		fprintf(RotFid,'%g\t',Tmp2);
		fprintf(RotFid,'\n');
		Tmp0((SensorNChan-1).*6+1:SensorNChan.*6)=Tmp2;
	end
	fclose(Fid);
	fclose(RotFid);
	RotPosNormMat=reshape(Tmp0,6,SensorNChan)';
end
