%==================================================================
%
%	SaveAvgFile.m
%
%	Markus Junghoefer	[1996]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
%
	function[File,Path,FilePath]=...
	SaveAvgFile(FilePath,AvgMat,NTrialAvgVec,StdChanTimeMat,SampRate,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra)
%
%==================================================================
if nargin<9; NChanExtra=0; end
if nargin<8; EegMegStatus=1; end	%1=EEG; 2=MEG
if nargin<7; MedMedAvgVec=[]; end
if nargin<6; MedMedRawVec=[]; end
if nargin<5; SampRate=[]; end
if nargin<4; StdChanTimeMat=[]; end
if nargin<3; NTrialAvgVec=[]; end
if nargin<2; AvgMat=[]; return; end

if isempty(FilePath)
	[File,Path,FilePath]=WriteFilePath('*.at','Choose a file name:');
else
	[File,Path]=SepFilePath(FilePath);
end
fprintf('\n\n');
fprintf('Start writing averaged data to file:\n\n');
disp(FilePath);
fprintf('\n');
fid=fopen(FilePath,'w','b');
fwrite(fid,'Version','char');
Version=4;
fwrite(fid,Version,'int16');
fwrite(fid,EegMegStatus,'float32');
fwrite(fid,NChanExtra,'float32');
SizeAvgMat=size(AvgMat);
NSizeAvgMat=length(SizeAvgMat);
if NSizeAvgMat>2
	SizeAvgMat=SizeAvgMat(NSizeAvgMat-1:NSizeAvgMat);
end
SizeStdChanTimeMat=size(StdChanTimeMat);
NSizeStdChanTimeMat=length(SizeStdChanTimeMat);
if NSizeStdChanTimeMat>2
	SizeStdChanTimeMat=SizeStdChanTimeMat(NSizeStdChanTimeMat-1:NSizeStdChanTimeMat);
end
fwrite(fid,SizeAvgMat,'float32');
fwrite(fid,AvgMat,'float32');
if ~isempty(NTrialAvgVec)
	fwrite(fid,size(NTrialAvgVec),'float32');
	fwrite(fid,NTrialAvgVec,'float32');
else
	fwrite(fid,[0 0],'float32');
end
if ~isempty(StdChanTimeMat)
	fwrite(fid,SizeStdChanTimeMat,'float32');
	fwrite(fid,StdChanTimeMat,'float32');
else
	NTrials=[];
	fwrite(fid,[0 0],'float32');
end
if ~isempty(SampRate)
	fwrite(fid,size(SampRate),'float32');
	fwrite(fid,SampRate,'float32');
else
	fwrite(fid,[0 0],'float32');
end
if ~isempty(MedMedRawVec)
	fwrite(fid,size(MedMedRawVec),'float32');
	fwrite(fid,MedMedRawVec,'float32');
else
	fwrite(fid,[0 0],'float32');
end
if ~isempty(MedMedAvgVec)
	fwrite(fid,size(MedMedAvgVec),'float32');
	fwrite(fid,MedMedAvgVec,'float32');
else
	fwrite(fid,[0 0],'float32');
end
fprintf('End writing averaged data to file.\n');
pause(1);

fclose(fid);
return;
