%=========================================================================
%
%	SaveData.m
%
%	Markus Junghoefer	[1996]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	
%	Function definition
% 
% 	function [SaveFilePath,EndPos] = SaveData(data,SaveFilePath,SaveDataStatus,...
% 									   string,precision1,precision2,...
% 									   status,offset,origin,InfoDataSize,...
% 									   InfoDataFile,DecVec,DefFileName)
% 
%================================================================================
	function [SaveFilePath,EndPos] = SaveData(data,SaveFilePath,SaveDataStatus,...
									   string,precision1,precision2,...
									   status,offset,origin,InfoDataSize,...
									   InfoDataFile,DecVec,DefFileName)	
%=================================================================
if nargin<13;DefFileName=[];end;
if nargin<12;DecVec=[];end;
if nargin<11;InfoDataFile=[];end;
if nargin<10;InfoDataSize=[];end;
if nargin<9;origin=[];end;
if nargin<8;offset=[];end;
if nargin<7;status=[];end;
if nargin<6;precision2=[];end;
if nargin<5;precision1=[];end;
if nargin<4;string=[];end;
if nargin<3;SaveDataStatus=[];end;
if nargin<2;SaveFilePath=[];end;

if ~SaveDataStatus; return; end;
if isempty(precision1); precision1='int16'; end
if isempty(precision2); precision2='float32'; end
if isempty(status); status=0; end
if isempty(offset); offset=0; end
if isempty(origin); origin=-1; end
if isempty(InfoDataFile); InfoDataFile=1; end
if isempty(InfoDataSize); InfoDataSize=1; end
if isempty(DecVec); DecVec=5; end
if isempty(DefFileName); DefFileName='Untitled'; end

fprintf('\n');
clc;
if isempty(string)
	[SaveDataStatus]=IfEmptyInputBo(['Do you want to save the data Y/N ?'],[],SaveDataStatus,1);
else
	[SaveDataStatus]=IfEmptyInputBo(string,['Do you want to save this data Y/N ?'],SaveDataStatus,1);
end
if ~SaveDataStatus; return; end

[m,n]=size(data);
	
if InfoDataSize; fprintf(1,'The data to save contains %g rows and %g columns.',m,n); pause(.5); end
if isempty(SaveFilePath)
	DefDataFilePath=SetDefPath(1,DefFileName);
	[SaveFile,SavePath]=uiputfile(DefDataFilePath,'Save data to file:')
	if SaveFile==0
		SaveFilePath=[]; EndPos=[]; return; 
	end
	SaveFilePath=[SavePath,SaveFile];
end
if status==0
	fid=fopen(SaveFilePath,'w','b');
elseif status==1
	fid=fopen(SaveFilePath,'r+','b');
end
if InfoDataFile
	fprintf('\n');clc;
	fprintf('Start writing data to file...\n\n');
	disp(SaveFilePath);fprintf('\n');
end
status=fseek(fid,offset,origin);

if strcmp(precision1,'ascii')	
	MaxSize=max([m n]);
	fprintf(fid,['%' num2str(floor(log10(MaxSize))+1) '.0f\t'],m);
	fprintf(fid,['%' num2str(floor(log10(MaxSize))+1) '.0f\n'],n);
elseif ~strcmp(precision1,'no')
	fwrite(fid,[m n],precision1);
end
if strcmp(precision2,'ascii')	
	MaxMaxAbs=max(max(abs(data)));
	if isempty(DecVec)
		[Dec]=IfEmptyInputValInt(['Please insert the decimal places:'],[],[],3,0,10,1);
		DecVec=Dec.*ones(m,1);
	end
	if length(DecVec)==1
		DecVec=DecVec.*ones(m,1);
	end
	if length(DecVec)~=m
		[Dec]=IfEmptyInputValInt(['Please insert the decimal places:'],[],[],3,0,10,1);
		DecVec=Dec.*ones(m,1);
	end
	for NInd=1:n
		for MInd=1:m
			if MInd==m
				if MaxMaxAbs==0
					DegOfAcc=['%1.' num2str(DecVec(MInd)) 'f\n'];
				else
					DegOfAcc=['%' num2str(floor(log10(MaxMaxAbs))+1) '.' num2str(DecVec(MInd)) 'f\n'];
				end
			else
				if MaxMaxAbs==0
					DegOfAcc=['%1.' num2str(DecVec(MInd)) 'f\t'];
				else
					DegOfAcc=['%' num2str(floor(log10(MaxMaxAbs))+1) '.' num2str(DecVec(MInd)) 'f\t'];
				end
			end
			fprintf(fid,DegOfAcc,data(MInd,NInd));
		end
	end
else
	fwrite(fid,data,precision2);
end
EndPos=ftell(fid);
fprintf('End writing data to file...\n\n');	
fclose(fid);	
	
return;
