%==================================================================
%
%	SaveMEGConfig.m
%
%	Markus Junghoefer	[1998]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%

%	Function definition

function[]=SaveMEGConfig(SensorPosNormMat,ChanNames,FileMask);

%=================================================================
 
[NChan,n]=size(SensorPosNormMat);

if nargin<3;
	FileMask=[int2str(NChan) '.pmg'];
end
[SaveFile,SavePath]=uiputfile(FileMask,'Save data to file:');
if SaveFile==0; return; end
SaveFilePath=[SavePath,SaveFile];

fprintf('Save MEG sensor configuration to file:\n')	
fprintf(SaveFilePath);
fprintf('\n');
fid=fopen(SaveFilePath,'w','b');
for ChanInd=1:NChan
	fprintf(fid,'Channel: "');
	fprintf(fid,deblank(ChanNames(ChanInd,:)));
	fprintf(fid,'"');
	fprintf(fid,'    %12.8f    %12.8f    %12.8f    %12.8f',SensorPosNormMat(ChanInd,:));
	fprintf(fid,'\n');
end
fclose(fid);
return;
