function [OutFileMat]=Scads2Besa(InFileMat,TrigPoint,CalcBaseStatus,MinBase,MaxBase,AddFileExt)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	Scads2Besa
%
%	Markus Junghoefer	[2001]
%
%
%	Function definition
%	
%	[OutFileMat]=Scads2Besa(InFileMat,TrigPoint,CalcBaseStatus,MinBase,MaxBase)
%
%
%
%=================================================================
if nargin<6; AddFileExt=[]; end
if nargin<5; MaxBase=[]; end
if nargin<4; MinBase=[]; end
if nargin<3; CalcBaseStatus=[]; end
if nargin<2; TrigPoint=[]; end
if nargin<1; InFileMat=[]; end

clc;
[TrigPoint]=IfEmptyInputVal('Please insert the trigger point:',[],TrigPoint,1,0);
[CalcBaseStatus]=IfEmptyInputBo('Do you want to subtract a baseline ?',[],CalcBaseStatus,1,1);
if CalcBaseStatus & (isempty(MinBase) | isempty(MaxBase))
	fprintf('\n')
	[NPointsBaseStatus]=IfEmptyInputBo('Do you want to use','the whole interval as baseline ?',[],1,0);
	if NPointsBaseStatus; 
		MinBase=[]; MaxBase=[]; 
	else
		[MinBase]=IfEmptyInputVal('Please insert the baseline start point:',[],MinBase,1,0);
		[MaxBase]=IfEmptyInputVal('Please insert the baseline end point:',[],MaxBase,max([1,TrigPoint-1]),0);
	end
end
[DefFilePath] = SetDefPath(1,'*.at*');
[NFilesIn,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose .at files or batch file:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);

if NFilesIn==0; return; end
if CalcBaseStatus
	FileExt=[AddFileExt,'.b'];
else
	FileExt=AddFileExt;
end

for FileInd=1:NFilesIn
	[InFile,InPath,InFilePath]=GetFileNameOfMat(InFileMat,FileInd);
	Nat=findstr(InFile,'.at');
	if Nat<length(InFile)-3
		OutFile=[InFile(1:Nat-1),FileExt,InFile(Nat+3:length(InFile)),'.avr'];
	else
		OutFile=[InFile(1:Nat-1),FileExt,'.avr'];
	end
	OutFilePath=[InPath,OutFile];
	[AvgMat,File,Path,FilePath,NTrialAvgVec,StdChanTimeMat,...
	SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra]=ReadAvgFile(InFilePath);
	if EegMegStatus==2 %MEG
		fprintf(1,'\n')
		fprintf(1,'MEG data:	Output Ascii Besa data in fT (x 10^15) ! \n')
		AvgMat=AvgMat.*10.^15;
	end
	[NChan,NPoints]=size(AvgMat);
	NChan=NChan-NChanExtra;
	if CalcBaseStatus
		if isempty(MinBase); MinBase=1; end
		if isempty(MaxBase); MaxBase=NPoints; end
		fprintf('Subtract baseline interval of points %g - %g.\n\n\n',MinBase,MaxBase);
		[AvgMat]=CalcBaseline(AvgMat,MinBase,MaxBase,CalcBaseStatus);
	else
		fprintf('No baseline subtraction.\n\n\n');
	end
	OutFid=fopen(OutFilePath,'w');
	if OutFid==-1; 
		fprintf(1,'Sorry, can not open file\n\n')
		fprintf(1,OutFilePath)
		fprintf(1,'\n\n')
		fprintf(1,'for writing.\n\n')
	else
		DI=1000./SampRate;
		TSB=(1-TrigPoint).*DI;		%Time-Speed-Begin
		fprintf(1,'Write %g points of %g sensors to file:\n\n',NPoints,NChan);
		fprintf(1,OutFilePath)
		fprintf(1,'\n\n');
		fprintf(1,'Set Time Speed Begin in Besa File to: %g = (1-TiggerPoint).*1000./SampRate !\n\n',TSB)
		fprintf(OutFid, 'Npts= %d  TSB= %f  DI= %f  SB= 1.000  SC= 1.0\n',NPoints,TSB,DI);
		for ChanInd=1:NChan
			fprintf(OutFid,'%g ',AvgMat(ChanInd,:));
			fprintf(OutFid,'\n');
		end
		fclose(OutFid);
		if FileInd==1
			OutFileMat=char(OutFilePath);
		else
			OutFileMat=char(OutFileMat,OutFilePath);
		end
	end
end
return;
