function[ValOut,StrOut]=String2Value(StrIn,ValIn,MinLim,MaxLim,RoundStatus,MinMaxLimStatus);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%==================================================================
%
%	String2Value
%
%	Markus Junghoefer	[2000]
%
%
%	Function definition
%	
%
%	MinMaxLimStatus==0 => Set to old value
%	MinMaxLimStatus==1 => Set to min./max value
%
%=================================================================

%==================================================================
if nargin<6; MinMaxLimStatus=0; end
if nargin<5; RoundStatus=0; end
if nargin<4; MaxLim=[]; end
if nargin<3; MinLim=[]; end
if nargin<2; ValIn=[]; end
if nargin<1; return; end

Ind = find(abs(StrIn)<32);
StrIn(Ind) = 32*ones(size(Ind));
StrIn = StrIn';	
ValOut = eval(['[' StrIn(:)' ']'],'-1')';
if length(ValOut)~=1
	ValOut=ValIn;
end
if RoundStatus
	ValOut=round(ValOut);
end
if ~isempty(MinLim)
	if ValOut<=MinLim
		if MinMaxLimStatus
			ValOut = MinLim;
		else
       		ValOut = ValIn;
		end
	end
end
if ~isempty(MaxLim)
	if ValOut>=MaxLim
		if MinMaxLimStatus
			ValOut = MaxLim;
       	else
       		ValOut = ValIn;
		end
	end
end
StrOut = sprintf('%g',ValOut);
return;
