function [] = WriteMat2EGIS(Mat,FilePath,ShiftDimOrder)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	WriteMat2Egis.m
%
%
%	Markus Junghoefer	[1999]
%
%
%
%	Function definition
%
%	function [] = WriteMat2EGIS(Mat,FilePath)
% 
% 	if nargin<2; FilePath=[]; end
% 	if nargin<1; FileMat=[]; end
%
%	[NTrials,NChan,NPoints]=size(Mat);
%
%=================================================================
if nargin<3; ShiftDimOrder=[]; end
if nargin<2; FilePath=[]; end
if nargin<1; Mat=[]; end

if isempty(Mat) | length(size(Mat))~=3
	return; 
end
%=========EGIS Header======================
global NTrials;
global NChan;	
global NPoints;	
if ~isempty(ShiftDimOrder)
	Mat=shiftdim(Mat,ShiftDimOrder);
end
[NTrials,NChan,NPoints]=size(Mat)
global BytOrd; 					BytOrd=[0 0 0 0];
global HdrVer; 					HdrVer=2;	
global LData;					LData=NTrials.*NChan.*NPoints.*2;
global LHeader;					LHeader=[];
global ExptNam;				    ExptNam=zeros(80,1);
ActTime=now;
ActTime=datestr(ActTime,0);
[Year,Month,Day,Hour,Minute,Sec] = datevec(ActTime);
global RunDate;					RunDate=[Day,Month,Year];
global RunTime; 				RunTime=[Hour,Minute,Sec];	
global SubjID;					SubjID=0;
global Handed;					Handed=0;
global Sex;						Sex=0;
global Age;						Age=0;
global ExperID;					ExperID=0;
global EdVer;					EdVer=2;	
global CalFlag;					CalFlag=0;
global LComment;				LComment=0;
global LText;					Bits=10;   		LText=Bits;		%Muss noch geaendert werden			
global LPad;					Range=366;		LPad=Range;		%Muss noch geaendert werden
global BrdGain;					BrdGain=1;				
global ChanGain;				ChanGain=ones(NChan,1);
global ChanZero;				ChanZero=zeros(NChan,1);
global CellName;				CellName=zeros(80,1);
global LHeader;					LHeader=[];
global NCells;					NCells=1;
global CellID;					CellID=0;  
global SampRate;				SampRate=1000;		
global LSpec;					LSpec=4;		
global LSpecCell1;				LSpecCell1=zeros(NTrials,LSpec./2);	
global LCellHdr;				LCellHdr=NCells.*90+NTrials.*LSpec;   %2.*(LSpec./2)
%==========================================
Fac=Range./(2.^Bits);
Mat=Mat./Fac;
[File,Path,FilePath]=WriteEGISHeader(FilePath);
Fid=fopen(FilePath,'r+','b');
fseek(Fid,LHeader,-1);
fprintf(1,'Write %g trials containing %g sensors and %g points to file:\n\n',NTrials,NChan,NPoints);
Message=char(['Write ' int2str(NTrials) ' trials containing ' int2str(NChan) ' channels and ' int2str(NPoints) ' points to file:']);
Message=char(Message,[]);
Message=char(Message,FilePath);
hmsgbox=msgbox(Message,'Info:','help');
pause(0.001);
for TrialInd=1:NTrials
	fprintf(1,'%g\n',TrialInd)	
	fwrite(Fid,squeeze(Mat(TrialInd,:,:)),'int16'); 
end
fclose(Fid);
return;
