% bslcorrWAMat
% subtracts the 2dimensional time-frequency matrix selected by the user
% from all submatrices(timepints) of 3dim WAmatrix


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
function[outWaMat] = bslcorrWAMat(inMat, timevec);

if nargin < 2
   timevec = input('give indices of the timevector to be used as baseline');
end

if nargin < 1
   [File, Path] = uigetfile('*');
   disp([Path File])
   eval(['load ' Path File]);
   inMat = AvgWaPower;
end


bslMat = squeeze(mean(inMat(:, :, timevec), 3));

size(bslMat)

for tpoint = 1 : length(inMat(1, 1, :));
   outWaMat(:, :, tpoint) = squeeze(inMat(:, :, tpoint))-bslMat;
end

