%==================================================================
%
%	calc_fig_axes_mov.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
	
	function[FigPos,AxesPos]=calc_fig_axes_mov(chView,Status,NWin,ActWin);

%
%
%=================================================================
if nargin<4; ActWin=1; end
if nargin<3; NWin=1; end


NRow=ceil(sqrt(NWin));
NCol=NRow;
ActRow=ceil(ActWin./NCol);
ActCol=ActWin-(ActRow-1).*NCol;
if NWin==1
	FigPos=[0 0 1 1];
else
	FigPos=[(ActRow-1)./NRow,1-ActCol./NCol,.95/NRow,.925/NCol];
end
if chView<=9
	FigPos(2)=.5.*FigPos(2);
end
if Status==1
	if chView<=9
		AxesPos=[ 0.0667    0.03300    0.8667   0.1071;...
   			       0.0667    0.175    0.8667   0.0536;...
    		       0.0667    0.3107    0.3940   0.1071;...
			       0.5394    0.3107    0.3940   0.1071;...
  			       0.15    0.45    0.7   0.5];
	else	 
		AxesPos=[0.033   0.033    0.4333    0.1071;...
   			   0.033   0.175     0.4333    0.0536;...
    		   0.033    0.3107    0.1970    0.1071;...
			   0.265    0.3107    0.1970    0.1071;...
  			   0.08    0.45   0.325    0.4821;...
			   0.533    0.0500    0.1970    0.2667;...
      		   0.8030    0.0500   0.1970    0.2667;...
  			   0.533    0.3667    0.1970    0.2667;...
 			   0.8030    0.3667   0.1970    0.2667;...
  			   0.533    0.6833    0.1970    0.2667;...
  			   0.8030    0.6833   0.1970    0.2667];
	end
elseif Status==2
	if chView<=9
		AxesPos=[  0.0667    0.0500    0.8667   0.1071;...
   			       0.0667    0.175    0.8667   0.0536;...
  			       0.0667    0.40    0.8667   0.6];
	else	 
		AxesPos=[0.033   0.033    0.4333    0.1071;...
   			   0.033   0.15     0.4333    0.0536;...
  			   0.01     0.4   0.5    0.5;...
			   0.533    0.0500    0.1970    0.2667;...
      		   0.8030    0.0500   0.1970    0.2667;...
  			   0.533    0.3667    0.1970    0.2667;...
 			   0.8030    0.3667   0.1970    0.2667;...
  			   0.533    0.6833    0.1970    0.2667;...
  			   0.8030    0.6833   0.1970    0.2667];
	end
end
AxesPos(1:5,1)=AxesPos(1:5,1)+.025;
AxesPos(:,3:4)=AxesPos(:,3:4)-0.01;
if chView>9
	AxesPos([6 8 10],1)=AxesPos([6 8 10],1)-.0;
	AxesPos([7 9 11],1)=AxesPos([7 9 11],1)-.03;
end

return;
