%==================================================================
%
%	calc_pol_med.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
	
	function[med_data,med_diff_data,med_std_data]=...
	calc_pol_med(data,e_names_mat)

%
%
%=================================================================


[m,n]=size(e_names_mat);
[p,q]=size(data);
med_data=zeros(m,q);
for i=1:m
	v=find(e_names_mat(i,:));
	v=e_names_mat(i,v);
	[r,s]=size(v);
	if s>1
		med_data(i,:)=median(data(v,:));
		med_std_data(i,:)=std(data(v,:));
	else
		med_data(i,:)=data(v,:);
		med_std_data(i,:)=zeros(1,q);
	end
	med_vec=sqrt(med_data(i,1).^2+med_data(i,2).^2+med_data(i,3).^2);
	for j=1:s
		med_diff_data(i,j)=sqrt((med_data(i,1)-data(v(j),1)).^2 ...
							+   (med_data(i,2)-data(v(j),2)).^2 ...
							+   (med_data(i,3)-data(v(j),3)).^2);
	end	
end

return;
