function [patchhandle]=plot3dbrain(XScalp,YScalp,ZScalp,CalcPotTmp,dlgstatus,axeshandle,HeadModel)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin <5;dlgstatus= 0;end
if nargin<1; potential3dfilepath=which('potential.mat'); load(potential3dfilepath,'XScalp','YScalp','ZScalp','CalcPotTmp');end

global patchmat vertexmat colors

if dlgstatus==1
    answer = questdlg('Wollen Sie den Standardkopf verwenden oder eine anderen?','Kopfform:','standard','anderen','standard');
    if strcmp(answer,'standard')
        if ~isempty(which('brain3dpatch.mat'))
         brain3dfilepath=which('brain3dpatch.mat');
                load(brain3dfilepath,'vertexmat','patchmat');
        else
            uiwait(errordlg('Konnte kein Standard-3d-file finden!','Achtung:'));
            readASE;
        end
    else
        readASE;
    end
else
    if HeadModel == 4
        if ~isempty(which('brain3dpatch.mat'))
             brain3dfilepath=which('brain3dpatch.mat');
             load(brain3dfilepath,'vertexmat','patchmat');
        else
            answer = questdlg('Konnte kein Standard-3d-file finden! Mchten Sie ein Asci-Export-File auswhlen?','Fehlendes 3d-file:','ja','nein','ja');
            if strcmp(answer,'ja')
                readASE;
            else
                return
            end
        end
    end
end

% %Auflsung Erhhen
% %-----------------
% 
% XScalp=interp2(XScalp,1);
% YScalp=interp2(YScalp,1);
% ZScalp=interp2(ZScalp,1),
% CalcPotTmp=interp2(CalcPotTmp,1);

%kopfposition auf Ursprung
%-------------------------
diameterx=abs((max(vertexmat(:,1))-min(vertexmat(:,1))));
diametery=abs((max(vertexmat(:,2))-min(vertexmat(:,2))));
diameterz=abs((max(vertexmat(:,2))-min(vertexmat(:,2))));
targetx=0-0.5*diameterx;
targety=0-0.5*diametery;
targetz=0-0.5*diameterz;
diffx=min(vertexmat(:,1))-targetx;
diffy=min(vertexmat(:,2))-targety;
diffz=min(vertexmat(:,3))-targetz;
vertexmat(:,1)=vertexmat(:,1)-diffx;
vertexmat(:,2)=vertexmat(:,2)-diffy;
vertexmat(:,3)=vertexmat(:,3)-diffz;

%Verschiebung
%--------------
if HeadModel==3
	vertexmat(:,3)=vertexmat(:,3)+0.6;
	vertexmat(:,2)=vertexmat(:,2);
end


kopfmittelpunkt = [0 0 0];

%calculate color
%-----------------
fig = figure('units','normalized','Position',[0.4 0.4 0.3 0.15],'menubar','none','Name','Progress:','Numbertitle','off');
ax=axes('Visible','off');
text2=text(0.1,0.6,'Calculate color at vertices ...');
text3=text(0.2,0.4,'0');
text4=text(0.4,0.4,['of  ',num2str(length(vertexmat))]);
pause(0.1);

for vertexzaehler=1:length(vertexmat)
      vertex=vertexmat(vertexzaehler,:);
      vertexmatx=ones(size(XScalp))*vertex(1);
      vertexmaty=ones(size(XScalp))*vertex(2);
      vertexmatz=ones(size(ZScalp))*vertex(3);
      x=zeros(size(XScalp,1),size(XScalp,2),2);
      y=zeros(size(x));
      z=zeros(size(x));
      x(:,:,1)=vertexmatx;
      x(:,:,2)=XScalp;
      y(:,:,1)=vertexmaty;
      y(:,:,2)=YScalp;
      z(:,:,1)=vertexmatz;
      z(:,:,2)=ZScalp;
      distmat=dist3d(x,y,z);
      minimum=find(distmat==min(min(distmat)));
      if length(minimum>1)
          minimum=minimum(1);
      end
      [i,j]=ind2sub(size(XScalp),minimum);
      colormat(vertexzaehler)=CalcPotTmp(i,j);
    if mod(vertexzaehler,20)==0
        clc;
        set(text3,'String',[num2str(vertexzaehler)]);
        pause(0.00001);
    end
end

vertexmat(:,2)=vertexmat(:,2)+1;
end
delete(ax);
close(fig);

%Skalierung
%------------
if HeadModel == 4
    vertexmat(:,2) = vertexmat(:,2)*0.83;%vorne-hinten
    vertexmat(:,2) = vertexmat(:,2)-0.08;
    vertexmat(:,1) = vertexmat(:,1)*0.65;%links-rechts
    vertexmat(:,3) = vertexmat(:,3)*0.7;%oben-unten
     vertexmat(:,3) = vertexmat(:,3)+0.6;%oben-unten
elseif HeadModel == 3
    vertexmat(:,2) = vertexmat(:,2)*0.97;
    vertexmat(:,1) = vertexmat(:,1)*0.97;
    vertexmat(:,3) = vertexmat(:,3)*0.97;
else
	vertexmat(:,1)=vertexmat(:,1)+diffx;
	vertexmat(:,2)=vertexmat(:,2)+diffy;
	vertexmat(:,3)=vertexmat(:,3)+diffz;
end


axes(axeshandle);
hold on
patchhandle=patch('Vertices',vertexmat,'Faces',patchmat,'CData',colormat','FaceColor','interp','EdgeColor','none','tag','brain3d','CDataMapping','scaled');

light('Position',[30 30 30],'Style','infinite','Color',[0.5 0.5 0.5]);
light('Position',[-30 30 30],'Style','infinite','Color',[0.5 0.5 0.5]);
light('Position',[30 -30 30],'Style','infinite','Color',[0.5 0.5 0.5]);
light('Position',[-30 -30 30],'Style','infinite','Color',[0.5 0.5 0.5]);
lighting phong;
material dull;
set(gca,'Color','none');
figurecolor=get(gcf,'Color');
% set(gca,'XTick',[]);
% set(gca,'YTick',[]);
% set(gca,'ZTick',[]);
% set(gca,'XTickLabel','');
% set(gca,'YTickLabel','');
% set(gca,'ZTickLabel','');
% set(gca,'XColor',figurecolor);
% set(gca,'YColor',figurecolor);
% set(gca,'ZColor',figurecolor);
% set(gca,'Color',figurecolor);
axis equal;



%Bereich vergrern
xlim=get(gca,'xlim');
ylim=get(gca,'ylim');
zlim=get(gca,'zlim');
nullmat=[0 0];

xlim=[-3.8 3.8];
ylim=[-2.5 5.0];
zlim=[-3, 4];

if HeadModel == 4
    zlim = [-5,4];
    ylim=[-4.5 5.0];
end


set(gca,'xlim',xlim);
set(gca,'ylim',ylim);
set(gca,'zlim',zlim);




return