function plotbrainsensors3d(EPosSpher,ENames,plotaxesstatus,SensorNameStatus,HeadModel)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if nargin < 4; SensorNameStatus=[]; end
if nargin < 3;    plotaxesstatus=0;end

if nargin<2 | isempty(ENames)
    ENames=num2str(linspace(1,length(EPosSpher),length(EPosSpher))');
end


convertstatus ='no';

besastatus = 0;
plot2dstatus = 1;
NChan=length(EPosSpher);
theta=EPosSpher(:,1);
phi=EPosSpher(:,2);
SpherRadiustmp=4;



%grad-pi-umwandlung
%-----------------
if ~isempty(find(theta>2*pi))
    phi=phi./360*2*pi;
    theta=theta./360*2*pi;
end


%positive Winkel
%------------------
phi(find(phi<0))=phi(find(phi<0))+2*pi;
phi(find(phi>(2*pi)))=phi(find(phi>(2*pi)))-2*pi;
theta(find(theta<0))=theta(find(theta<0))+2*pi;
theta(find(theta>(2*pi)))=theta(find(theta>(2*pi)))-2*pi;

%drehen des sphere-coordinaten-systems;
%-----------------------
theta=pi/2-theta;
tmp=theta;
theta=phi;
phi=tmp;

%positive Winkel
%------------------
phi(find(phi<0))=phi(find(phi<0))+2*pi;
phi(find(phi>(2*pi)))=phi(find(phi>(2*pi)))-2*pi;
theta(find(theta<0))=theta(find(theta<0))+2*pi;
theta(find(theta>(2*pi)))=theta(find(theta>(2*pi)))-2*pi;

radians=ones(1,length(theta))*SpherRadiustmp;
radians=radians';
[x,y,z]=sph2cart(theta,phi,radians);

%Stauchen in X-Richtung
%---------------------

x=x*0.706;
x=x-0;
%Stauchen in Y-Richtung
%---------------------
y=y*0.9;
y=y+1.0;

%Verschieben in Z-Richtung
%---------------------
z=z*0.86;
z=z+0.0;

hold on
electrodes=plot3(x,y,z,'o','markerfacecolor',[0 0 0],'markerEdgeColor',[0 0 0]);

%Rckwandeln in spherische Coordinates
%-------------
[theta,phi,radians]=cart2sph(x,y,z);


%positive Winkel
%------------------
phi(find(phi<0))=phi(find(phi<0))+2*pi;
phi(find(phi>(2*pi)))=phi(find(phi>(2*pi)))-2*pi;
theta(find(theta<0))=theta(find(theta<0))+2*pi;
theta(find(theta>(2*pi)))=theta(find(theta>(2*pi)))-2*pi;


%Strahlen
%-----------
zerovec=zeros(size(x))';
for j=1:length(x)
    plot3([zerovec(j),x(j)],[zerovec(j),y(j)],[zerovec(j),z(j)],'color',[0 0 0]);
end

%Elektrodennamen
%------------------
if SensorNameStatus
    text(x+x*0.1,y+y*0.1,z+z*0.1,ENames);
end



if plotaxesstatus==1
    
	%Bereich vergrern
	xlim=get(gca,'xlim');
	ylim=get(gca,'ylim');
	zlim=get(gca,'zlim');
	nullmat=[0 0];
	xlim=[-1*abs(max(xlim))*2, abs(max(xlim))*2];
	ylim=[-1*abs(max(ylim))*3, abs(max(ylim))*3];
	zlim=[-1*abs(max(zlim))*3, abs(max(zlim))*3];
	set(gca,'xlim',xlim);
	set(gca,'ylim',ylim);
	set(gca,'zlim',zlim);
	%Achsen
	xachse=plot3(xlim,nullmat,nullmat,'color',[0 0 0],'linewidth',2);
	yachse=plot3(nullmat,ylim,nullmat,'color',[0 0 0],'linewidth',2);
	zachse=plot3(nullmat,nullmat,zlim,'color',[0 0 0],'linewidth',2);
	%Achsentitel
	text(max(xlim)+max(xlim)*0.3,  0+max(ylim)*0.1,0+max(zlim)*0.1,'X(right)','color',[0 0 0],'fontsize',14);
	text(0+max(xlim)*0.1,min(ylim)-max(ylim)*0.3,0+max(zlim)*0.1,'Y(back)','color',[0 0 0],'fontsize',14);
	text(0+max(xlim)*0.1,0+max(ylim)*0.1,min(zlim)-max(zlim)*0.3,'Z(bottom)','color',[0 0 0],'fontsize',14);
	
	% 
	% %figure stylen
	% %---------------
	% 
	% set(gca,'Color','none');
	% figurecolor=get(gcf,'Color');
	% set(gca,'XTick',[]);
	% set(gca,'YTick',[]);
	% set(gca,'ZTick',[]);
	% set(gca,'XTickLabel','');
	% set(gca,'YTickLabel','');
	% set(gca,'ZTickLabel','');
	% set(gca,'XColor',figurecolor);
	% set(gca,'YColor',figurecolor);
	% set(gca,'ZColor',figurecolor);
	% set(gca,'Color',figurecolor);
	
	%Pfeile der Achsen
	%-----------------
	%X-Achse
	%---------
	c1scaling=0.5;
	c2scaling=0.5;
	c3scaling=0.8;
	%Pfeil
	[c1,c2,c3] = cylinder(linspace(0,max(xlim)/10,20),20);
	c1=c1-ones(size(c1))*mean(mean(c1));
	c1=c1*c1scaling;
	c2=c2-ones(size(c2))*mean(mean(c2));
	c2=c2*c2scaling;
	c3=c3-ones(size(c3))*mean(mean(c3));
	c3=c3*c3scaling;
	cylinderhandle=surf(c1,c2,c3,'EdgeColor','none');
	%Drehen in Achsenrichtung
	rotate(cylinderhandle,[0 1 0],270);
	c1=get(cylinderhandle,'XData');
	c2=get(cylinderhandle,'YData');
	c3=get(cylinderhandle,'ZData');
	%Verschiebung in y-Richtung
	c1=c1+ones(size(c1))*max(xlim);
	cylinderhandle=surf(c1,c2,c3,'EdgeColor','none','FaceColor',[0 0 0]);
	%Y-Achse
	%---------
	c1scaling=0.5;
	c2scaling=0.5;
	c3scaling=0.8;
	%Pfeil
	[c1,c2,c3] = cylinder(linspace(0,max(xlim)/10,20),20);
	c1=c1-ones(size(c1))*mean(mean(c1));
	c1=c1*c1scaling;
	c2=c2-ones(size(c2))*mean(mean(c2));
	c2=c2*c2scaling;
	c3=c3-ones(size(c3))*mean(mean(c3));
	c3=c3*c3scaling;
	cylinderhandle=surf(c1,c2,c3);
	%Drehen in Achsenrichtung
	rotate(cylinderhandle,[1 0 0],270);
	c1=get(cylinderhandle,'XData');
	c2=get(cylinderhandle,'YData');
	c3=get(cylinderhandle,'ZData');
	%Verschiebung in y-Richtung
	c2=c2-ones(size(c2))*max(ylim);
	cylinderhandle=surf(c1,c2,c3,'EdgeColor','none','FaceColor',[0 0 0]);
	%Z-Achse
	%----------
	c1scaling=0.5;
	c2scaling=0.5;
	c3scaling=0.8;
	%Pfeil
	[c1,c2,c3] = cylinder(linspace(0,max(xlim)/10,20),20);
	c1=c1-ones(size(c1))*mean(mean(c1));
	c1=c1*c1scaling;
	c2=c2-ones(size(c2))*mean(mean(c2));
	c2=c2*c2scaling;
	c3=c3-ones(size(c3))*mean(mean(c3));
	c3=c3*c3scaling;
	cylinderhandle=surf(c1,c2,c3);
	%Drehen in Achsenrichtung
	rotate(cylinderhandle,[0 1 0],0);
	c1=get(cylinderhandle,'XData');
	c2=get(cylinderhandle,'YData');
	c3=get(cylinderhandle,'ZData');
	%Verschiebung in z-Richtung
	c3=c3-ones(size(c3))*max(zlim);
	cylinderhandle=surf(c1,c2,c3,'EdgeColor','none','FaceColor',[0 0 0]);

end

hold off
return  




