% For given leadfield and InvSolerse solution, the residual variance (sum of squares of differences
% divided by sum of squares of Data) of the forward solution of the InvSolerse solution and
% the Data (columns of "Data") is computed and output for every column of "Data"
% OH 05.12.97

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
% uses norm_col()

function [resvar,forward]=res_var(LfdMat,InvSol,Data);

if nargin==0,
   disp(' resvar = res_var(LfdMat, InvSol, Data) ');
   return;
end,
if length(LfdMat(:,1))~=length(Data(:,1)),
   disp('Numbers of channels of LfdMat and Data do not match!!! (res_var) ');
   return;
end,
if length(LfdMat(1,:))~=length(InvSol(:,1)),
   disp('Dimensions of source space of LfdMat and InvSol do not match!!! (res_var) ');
   return;
end,
forward = LfdMat*InvSol;
diff = Data-forward;
diffnorm = norm_col(diff,2);
clear diff;
datnorm = norm_col(Data,2);
resvar=(diffnorm./datnorm)';
return;
