%==================================================================
%
%	title_string_func.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
	
	function[title_string]=title_string_func(title_num,status)

%
%
%=================================================================


if status==1
	if title_num == 1
		title_string=['Griddata interpolated Scalp-Potential'];
	elseif title_num ==2
			title_string=['Intracranial Potential Estimation'];
	elseif title_num ==3
		title_string=['Scalp-Laplacian'];
	elseif title_num ==4
		title_string=['Cortex-Laplacian (Interp.:Spline, Laplacian:Matlab)'];
	elseif title_num ==5
		title_string=['Difference between normalized Scalp and Cortex Potential'];
	elseif title_num ==6
		title_string=['Scalp-Potential'];
	elseif title_num ==7
		title_string=['Scalp-Potential (Perrin)'];
	elseif title_num ==8
		title_string=['Scalp-Laplacian (Interp.:Spline, Laplacian:Matlab)'];
	elseif title_num ==9
		title_string=['Scalp-Laplacian (using del2 (Matlab))'];
	elseif title_num ==10
		title_string=['Scalp-Laplacian (Perrin)'];
	elseif title_num ==11
		title_string=['Calculated 2-d FFT of the Scalp Potential (abs)'];
	elseif title_num ==12
		title_string=['Calculated 2-d FFT of the Scalp Potential (real)'];
	elseif title_num ==13
		title_string=['Calculated 2-d FFT of the Scalp Potential (imag) (No.13)'];
	elseif title_num ==14
		title_string=['Synthetic Scalp Potential'];
	elseif title_num ==15
		title_string=['Difference between Synthetic- and Perrin spline interpolated- Scalp Potential'];
	elseif title_num ==16
		title_string=['Scalp-Laplacian (Interp.:Perrin, Laplacian:Matlab)'];
	elseif title_num ==17
		title_string=['Scalp-Laplacian'];
	elseif title_num ==18
		title_string=['Scalp-Potential'];
	elseif title_num ==19
		title_string=['Difference between Synthetic- and griddata interpolated Scalp Potential'];
	elseif title_num ==20
		title_string=['Difference between Synthetic- and spline interpolated- Scalp Potential'];
	elseif title_num ==21
		title_string=['Laplacian of Intracranial Potential Estimation'];	
	elseif title_num ==22
		title_string=['Direction values for theta_phi'];
	elseif title_num ==23
		title_string=['U-matrix of SVD'];	
	elseif title_num ==24
		title_string=['Music - Localization'];		
	elseif title_num ==25
		title_string=['App. Scalp-Potential'];
	elseif title_num ==26
		title_string=['App. Laplacian of Scalp-Potential'];
	elseif title_num ==27
		title_string=['App. Intracranial Potential Estimation'];
	elseif title_num ==28
		title_string=['App. Laplacian of Intracranial Potential Estimation'];
	elseif title_num ==29
		title_string=['Distribution of vector of approximation'];
	elseif title_num ==30
		title_string=['Grand Mean of Scalp Potentials'];
	elseif title_num ==31
		title_string=['Average of Grand Mean of Scalp Potentials'];
	elseif title_num ==32
		title_string=['App. Scalp-Potential (Perrin)'];
	elseif title_num ==33
		title_string=['App. Scalp-Laplacian (Perrin)'];
	elseif title_num ==51
		title_string=['L2 Minimum Norm; 4 Shells; Shell: 8 cm'];
	elseif title_num ==52
		title_string=['L2 Minimum Norm; 4 Shells; Shell: 6 cm'];
	elseif title_num ==53
		title_string=['L2 Minimum Norm; 4 Shells; Shell: 4 cm'];
	elseif title_num ==54
		title_string=['L2 Minimum Norm; 4 Shells; Shell: 2 cm'];
	elseif title_num ==55
		title_string=['L2 Minimum Norm; 1 Shell; Shell: 8 cm'];
	elseif title_num ==56
		title_string=['L2 Minimum Norm; 1 Shell; Shell: 6 cm'];
	elseif title_num ==57
		title_string=['Scalp Distribution of Power FFT'];
	elseif title_num ==58
		title_string=['App. Scalp Distribution of Power FFT'];
	elseif title_num ==59
		title_string=['Laplacian of Power FFT'];
	elseif title_num ==60
		title_string=['App. Laplacian of Power FFT'];
	elseif title_num ==61
		title_string=['Intracranial Potential Estimation of Power FFT'];
	elseif title_num ==62
		title_string=['App. Intracranial Potential Estimation of Power FFT'];
	elseif title_num ==63
		title_string=['Perrin Scalp Distribution of Power FFT'];
	elseif title_num ==64 
		title_string=['App. Perrin Scalp Distribution of Power FFT'];
	elseif title_num ==65
		title_string=['Perrin Laplacian of Power FFT'];
	elseif title_num ==66
		title_string=['App. Perrin Laplacian of Power FFT'];
	elseif title_num ==67
		title_string=['Inverse L2 MN of P-FFT; 4 Shells; Shell: 8 cm'];
	elseif title_num ==68
		title_string=['Inverse L2 MN of P-FFT; 4 Shells; Shell: 6 cm'];
	elseif title_num ==69
		title_string=['Inverse L2 MN of P-FFT; 4 Shells; Shell: 4 cm'];
	elseif title_num ==70
		title_string=['Inverse L2 MN of P-FFT; 4 Shells; Shell: 2 cm'];
	elseif title_num ==71
		title_string=['Inverse L2 MN of P-FFT; 1 Shell; Shell: 8 cm'];
	elseif title_num ==72
		title_string=['Inverse L2 MN of P-FFT; 1 Shell; Shell: 6 cm'];
	elseif title_num ==73
		title_string=['Magnetic Field (projected onto a sphere)'];
	elseif title_num ==74
		title_string=['P-FFT of Magnetic Field (projected onto a sphere)'];
	elseif title_num ==75
		title_string=['App. Magnetic Field (projected onto a sphere)'];
	elseif title_num ==76
		title_string=['App. P-FFT of Magnetic Field (projected onto a sphere)'];
	elseif title_num ==77
		title_string=['Laplacian of Magnetic Field (projected onto a sphere)'];
	elseif title_num ==78
		title_string=['Laplacian of P-FFT of Magnetic Field (projected onto a sphere)'];
	elseif title_num ==79
		title_string=['App. Laplacian of Magnetic Field (projected onto a sphere)'];
	elseif title_num ==80
		title_string=['App. Laplacian of P-FFT of Magnetic Field (projected onto a sphere)'];
	elseif title_num ==81
		title_string=['Intracranial Magnetic Field Estimation'];
	elseif title_num ==82
		title_string=['Intracranial Magnetic Field Estimation of Power FFT'];
	elseif title_num ==83
		title_string=['App. Intracranial Magnetic Field Estimation'];
	elseif title_num ==84
		title_string=['App. Intracranial Magnetic Field Estimation of Power FFT'];
	elseif title_num ==85
		title_string=['Magnetic Field (projected onto a sphere; Perrin)'];
	elseif title_num ==86
		title_string=['P-FFT of Magnetic Field (projected onto a sphere; Perrin)'];
	elseif title_num ==87
		title_string=['App. Magnetic Field (projected onto a sphere; Perrin)'];
	elseif title_num ==88
		title_string=['App. P-FFT of Magnetic Field (projected onto a sphere; Perrin)'];
	elseif title_num ==89
		title_string=['Laplacian of Magnetic Field (projected onto a sphere; Perrin)'];
	elseif title_num ==90
		title_string=['Laplacian of P-FFT of Magnetic Field (projected onto a sphere; Perrin)'];
	elseif title_num ==91
		title_string=['App. Laplacian of Magnetic Field (projected onto a sphere; Perrin)'];
	elseif title_num ==92
		title_string=['App. Laplacian of P-FFT of Magnetic Field (projected onto a sphere; Perrin)'];
   elseif title_num ==93
		title_string=['PCA Components'];
   elseif title_num ==94
      title_string=['PCA Components'];
   elseif title_num ==95
		title_string=['App. PCA Components'];
   elseif title_num ==96
      title_string=['App. PCA Components'];
   elseif title_num ==97
		title_string=['"Laplacian" of PCA Components'];
   elseif title_num ==98
      title_string=['"Laplacian" of PCA Components'];
   elseif title_num ==99
		title_string=['App. "Laplacian" of PCA Components'];
   elseif title_num ==100
		title_string=['App. "Laplacian" of PCA Components'];
	elseif title_num ==101
		title_string=['"Intracranial Estimation" of PCA Components'];
   elseif title_num ==102
      title_string=['"Intracranial Estimation" of PCA Components'];
   elseif title_num ==103
		title_string=['App. "Intracranial Estimation" of PCA Components'];
   elseif title_num ==104
		title_string=['App. "Intracranial Estimation" of PCA Components'];
	elseif title_num ==105
		title_string=['PCA Components (Perrin Interp.)'];
   elseif title_num ==106
      title_string=['PCA Components (Perrin Interp.)'];
   elseif title_num ==107
		title_string=['App. PCA Components (Perrin Interp.)'];
   elseif title_num ==108
      title_string=['App. PCA Components (Perrin Interp.)'];
	elseif title_num ==109
		title_string=['"Laplacian" of PCA Components (Perrin Interp.)'];
   elseif title_num ==110
      title_string=['"Laplacian" of PCA Components (Perrin Interp.)'];
   elseif title_num ==111
      title_string=['App. "Laplacian" of PCA Components (Perrin Interp.)'];
   elseif title_num ==112
		title_string=['App. "Laplacian" of PCA Components (Perrin Interp.)'];
	elseif title_num ==113
      title_string=['Inverse L2 MN of PCA; 4 Shells; Shell: 8 cm'];
   elseif title_num ==114
		title_string=['Inverse L2 MN of PCA; 4 Shells; Shell: 6 cm'];
	elseif title_num ==115
      title_string=['Inverse L2 MN of PCA; 4 Shells; Shell: 4 cm'];
   elseif title_num ==116
      title_string=['Inverse L2 MN of PCA; 4 Shells; Shell: 2 cm'];
   elseif title_num ==117
		title_string=['Inverse L2 MN of PCA; 1 Shell; Shell: 8 cm'];
	elseif title_num ==118
		title_string=['Inverse L2 MN of PCA; 1 Shell; Shell: 6 cm'];
	else
		error('Wrong title number')
	end
elseif status==2
	if title_num == 1
		title_string=['back'];
	elseif title_num ==2
		title_string=['front'];
	elseif title_num ==3
		title_string=['top'];
	elseif title_num ==4
		title_string=['bottom'];
	elseif title_num ==5
		title_string=['left'];
	elseif title_num ==6
		title_string=['right'];
	end
elseif status==3
	if title_num ==1
		title_string=['Comparison between Scalp Potential, Laplacian and Cortical Map'];
	elseif title_num ==2
		title_string=['Comparison between synthetic or interpolated Scalp Potential and Laplacian resp. Cortical Map'];
	elseif title_num ==3
		title_string=['Comparison between Scalp Potential Interpolation and Scalp Potential Approximation'];
	end
end

return;

