function BatchResults(ConStart,ConEnd,SubVec,SubgroupDir,uu,k)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
clear all
if nargin<1; ConStart=[]; end
if nargin<2; ConEnd=[]; end
if nargin<3; SubVec=[]; end
if nargin<4; SubgroupDir=[]; end
if nargin<5; uu=[]; end
if nargin<6; k=[]; end

global BATCHMJ BATCHMJSPM BATCHMJVOL GraphMJ hReg PRINTSTR MaskMat

%Changes in (search for BATCHMJ):
%spm_spm_ui
%spm_result_ui
%spm_getSPM
%spm_conman
%spm_render

if isempty(ConStart); ConStart=1; end %Starts with Con+1
if isempty(ConEnd);   ConEnd=[1];  end %Ends with Con+1; if isempty(ConEnd); ConEnd=size(F.names,2); end
if isempty(SubgroupDir); SubgroupDir='Male'; end
if isempty(uu); uu=0.05; end
if isempty(k);  k=10; end

PrintFullGlassStatsStatus=0;
WriteFilteredStatus=0;
CalcVoiStatus=1;

ucStr='u' % 'u'=>uncorrected; 'c'=>corrected
uuStr=uu.*1000;
if uuStr<10
    uuStr=['00',num2str(uuStr)] 
elseif uuStr<100
    uuStr=['0',num2str(uuStr)]
else
    uuStr=num2str(uuStr)
end
kStr=int2str(k);

BATCHMJ.ucStr=ucStr
BATCHMJ.uu=uu;
BATCHMJ.k=k
BATCHMJ.SPACE='I'
BATCHMJ.TabDat=[]
BATCHMJ.Cp=3    %'Event/epoch-related responses'
BATCHMJ.rep=1
BATCHMJ.tr=1:5
BATCHMJ.Cr=1    %fitted response
BATCHMJ.jsc='stay'
BATCHMJ.ssstart=1      %1 == 09 Slow;  2 == 36 Fast
BATCHMJ.ssstep=1
BaseStr='0';
SmoothStr='08';

FlipStatus=0;
if isempty(SubVec)   
    FemaleVec=[7 9 10 11 13 14 16 17 18 20 22]
    MaleVec  =[3 4  5  6  12 15 21 23 24 25] % 2
    if strcmp(SubgroupDir,'All') | strcmp(SubgroupDir,'Gender')
        SubVec=[MaleVec,FemaleVec]
    elseif strcmp(SubgroupDir,'Female')
        SubVec=FemaleVec
    elseif strcmp(SubgroupDir,'Male')
        SubVec=MaleVec
    end
end
NSub=length(SubVec);


%=================================================================
F = struct( ...
    'names',  {{...
            'CPosHiGTNeutAll','CPosHiLTNeutAll','CNegHiGTNeutAll','CNegHiLTNeutAll','CPosLoGTNeutAll',...
            'CPosLoLTNeutAll','CNegLoGTNeutAll','CNegLoLTNeutAll','CPosHiGTNegHiAll','CPosHiLTNegHiAll',...                 %10
            'CPosLoGTNegLoAll','CPosLoLTNegLoAll','CAroHiGTLoAll','CAroHiLTLoAll','CAroLinHiGTLoAll',...
            'CAroLinHiLTLoAll','CAroExp1HiGTLoAll','CAroExp1HiLTLoAll','CAroExp2HiGTLoAll','CAroExp2HiLTLoAll',...           %20
            'CValPosGTNegAll','CValPosLTNegAll','CPosHiGTNeutSlow','CPosHiLTNeutSlow','CNegHiGTNeutSlow',...
            'CNegHiLTNeutSlow','CPosLoGTNeutSlow','CPosLoLTNeutSlow','CNegLoGTNeutSlow','CNegLoLTNeutSlow',...               %30
            'CPosHiGTNegHiSlow','CPosHiLTNegHiSlow','CPosLoGTNegLoSlow','CPosLoLTNegLoSlow','CAroHiGTLoSlow',...
            'CAroHiLTLoSlow','CAroLinHiGTLoSlow','CAroLinHiLTLoSlow','CAroExp1HiGTLoSlow','CAroExp1HiLTLoSlow',...           %40
            'CAroExp2HiGTLoSlow','CAroExp2HiLTLoSlow','CValPosGTNegSlow','CValPosLTNegSlow','CPosHiGTNeutFast',...
            'CPosHiLTNeutFast','CNegHiGTNeutFast','CNegHiLTNeutFast','CPosLoGTNeutFast','CPosLoLTNeutFast',...               %50
            'CNegLoGTNeutFast','CNegLoLTNeutFast','CPosHiGTNegHiFast','CPosHiLTNegHiFast','CPosLoGTNegLoFast',...             
            'CPosLoLTNegLoFast','CAroHiGTLoFast','CAroHiLTLoFast','CAroLinHiGTLoFast','CAroLinHiLTLoFast',...                 %60
            'CAroExp1HiGTLoFast','CAroExp1HiLTLoFast','CAroExp2HiGTLoFast','CAroExp2HiLTLoFast','CValPosGTNegFast',...
            'CValPosLTNegFast','CFastGTSlow','CFastLTSlow','CFastGTSlowNegHi','CFastLTSlowNegHi',...                            %70
            'CFastGTSlowNegLo','CFastLTSlowNegLo','CFastGTSlowNeut','CFastLTSlowNeut','CFastGTSlowPosLo',...
            'CFastLTSlowPosLo','CFastGTSlowPosHi','CFastLTSlowPosHi','CFastGTSlowHiAro','CFastLTSlowHiAro',...                  %80
            'CFastGTSlowLoAro','CFastLTSlowLoAro','CFastGTSlowNegVal','CFastLTSlowNegVal','CFastGTSlowPosVal', ...
            'CFastLTSlowPosVal','CPosHiLTPosLoAll','CPosHiGTPosLoAll','CPosHiLTPosLoSlow','CPosHiGTPosLoSlow', ...              %90
            'CPosHiLTPosLoFast','CPosHiGTPosLoFast','CNegHiLTNegLoAll','CNegHiGTNegLoAll','CNegHiLTNegLoSlow', ...
            'CNegHiGTNegLoSlow','CNegHiLTNegLoFast','CNegHiGTNegLoFast','CPosHiLTNegLoAll','CPosHiGTNegLoAll', ...             %100
            'CPosHiLTNegLoSlow','CPosHiGTNegLoSlow','CPosHiLTNegLoFast','CPosHiGTNegLoFast','CNegHiLTPosLoAll', ...
            'CNegHiGTPosLoAll', 'CNegHiLTPosLoSlow','CNegHiGTPosLoSlow','CNegHiLTPosLoFast','CNegHiGTPosLoFast', ...            %110
            'CAroHiGTLoNoNeutralAll','CAroHiLTLoNoNeutralAll','CAroHiGTLoNoNeutralSlow','CAroHiLTLoNoNeutralSlow','CAroHiGTLoNoNeutralFast',...
            'CAroHiLTLoNoNeutralFast','CAroLoGTNeutralAll','CAroLoLTNeutralAll','CAroLoGTNeutralSlow','CAroLoLTNeutralSlow',... %120
            'CAroLoGTNeutralFast','CAroLoLTNeutralFast','CAroHiGTNeutralAll','CAroHiLTNeutralAll','CAroHiGTNeutralSlow',...
            'CAroHiLTNeutralSlow','CAroHiGTNeutralFast','CAroHiLTNeutralFast', ...
        }})
%=================================================================
MaskPath='C:\Programme\Matlab12\toolbox\spm99\masken\';
% MaskFileMat=char('ac_l.img');                 
% MaskFileMat=char(MaskFileMat,'ac_r.img');                   
% MaskFileMat=char(MaskFileMat,'amy_l_us.img');               
% MaskFileMat=char(MaskFileMat,'amy_r_us.img');               
% MaskFileMat=char(MaskFileMat,'bg_l_us.img');                
% MaskFileMat=char(MaskFileMat,'bg_r_us.img');                
% MaskFileMat=char(MaskFileMat,'hipp_para_l_us.img');     
% MaskFileMat=char(MaskFileMat,'hipp_para_r_us.img');     
% MaskFileMat=char(MaskFileMat,'ins_l_us.img');               
% MaskFileMat=char(MaskFileMat,'ins_r_us.img');               
% MaskFileMat=char(MaskFileMat,'mpc_l.img');                  
% MaskFileMat=char(MaskFileMat,'mpc_r.img');                  
% MaskFileMat=char(MaskFileMat,'obf_l_us.img');               
% MaskFileMat=char(MaskFileMat,'obf_r_us.img');               
% MaskFileMat=char(MaskFileMat,'oc_l.img');                   
% MaskFileMat=char(MaskFileMat,'oc_r.img');                   
% MaskFileMat=char(MaskFileMat,'pc_l_us.img'); 
% MaskFileMat=char(MaskFileMat,'pc_r_us.img'); 
% MaskFileMat=char(MaskFileMat,'tha_l.img');                  
% MaskFileMat=char(MaskFileMat,'tha_r.img');   
% OrbitFront_l.img     
% OrbitFront_r.img     
% mpc_l.img            
% mpc_r.img            
% oc_l.img             
% oc_r.img    

MaskFileMat=char('PreCentral_l.img');    
MaskFileMat=char(MaskFileMat,'Precentral_r.img'); 
MaskFileMat=char(MaskFileMat,'PostCentral_l.img');
MaskFileMat=char(MaskFileMat,'PostCentral_r.img');
MaskFileMat=char(MaskFileMat,'RolOper_l.img');    
MaskFileMat=char(MaskFileMat,'RolOper_r.img');
MaskFileMat=char(MaskFileMat,'SupFrontDorsLat_l.img');
MaskFileMat=char(MaskFileMat,'SupFrontDorsLat_r.img');
MaskFileMat=char(MaskFileMat,'MidFrontLat_l.img');    
MaskFileMat=char(MaskFileMat,'MidFrontLat_r.img'); 
MaskFileMat=char(MaskFileMat,'InfFrontOper_l.img');   
MaskFileMat=char(MaskFileMat,'InfFrontOper_r.img');    
MaskFileMat=char(MaskFileMat,'InfFrontTri_l.img');    
MaskFileMat=char(MaskFileMat,'InfFrontTri_r.img');
MaskFileMat=char(MaskFileMat,'SupFrontMed_l.img');    
MaskFileMat=char(MaskFileMat,'SupFrontMed_r.img'); 
MaskFileMat=char(MaskFileMat,'SMA_l.img');            
MaskFileMat=char(MaskFileMat,'SMA_r.img');  
MaskFileMat=char(MaskFileMat,'ParaCentral_l.img');    
MaskFileMat=char(MaskFileMat,'ParaCentral_r.img'); 
MaskFileMat=char(MaskFileMat,'SupFrontOrb_l.img');    
MaskFileMat=char(MaskFileMat,'SupFrontOrb_r.img'); 
MaskFileMat=char(MaskFileMat,'SupFrontMedOrb_l.img');    
MaskFileMat=char(MaskFileMat,'SupFrontMedOrb_r.img');
MaskFileMat=char(MaskFileMat,'MidFrontOrb_l.img');    
MaskFileMat=char(MaskFileMat,'MidFrontOrb_r.img');  
MaskFileMat=char(MaskFileMat,'InfFrontOrb_l.img');
MaskFileMat=char(MaskFileMat,'InfFrontOrb_r.img');
MaskFileMat=char(MaskFileMat,'RectOrb_l.img');        
MaskFileMat=char(MaskFileMat,'RectOrb_r.img'); 
MaskFileMat=char(MaskFileMat,'Olfac_l.img');          
MaskFileMat=char(MaskFileMat,'Olfac_r.img');   
MaskFileMat=char(MaskFileMat,'SupTemp_l.img');        
MaskFileMat=char(MaskFileMat,'SupTemp_r.img'); 
MaskFileMat=char(MaskFileMat,'Heschl_l.img');         
MaskFileMat=char(MaskFileMat,'Heschl_r.img');  
MaskFileMat=char(MaskFileMat,'MidTemp_l.img');        
MaskFileMat=char(MaskFileMat,'MidTemp_r.img');   
MaskFileMat=char(MaskFileMat,'InfTemp_l.img');        
MaskFileMat=char(MaskFileMat,'InfTemp_r.img'); 
MaskFileMat=char(MaskFileMat,'SupPar_l.img');         
MaskFileMat=char(MaskFileMat,'SupPar_r.img'); 
MaskFileMat=char(MaskFileMat,'InfPar_l.img');         
MaskFileMat=char(MaskFileMat,'InfPar_r.img');  
MaskFileMat=char(MaskFileMat,'Angular_l.img');        
MaskFileMat=char(MaskFileMat,'Angular_r.img');  
MaskFileMat=char(MaskFileMat,'SupraMarg_l.img');      
MaskFileMat=char(MaskFileMat,'SupraMarg_r.img');
MaskFileMat=char(MaskFileMat,'Precuneus_l.img');      
MaskFileMat=char(MaskFileMat,'Precuneus_r.img');  
MaskFileMat=char(MaskFileMat,'SupOcc_l.img');         
MaskFileMat=char(MaskFileMat,'SupOcc_r.img');  
MaskFileMat=char(MaskFileMat,'MidOcc_l.img');         
MaskFileMat=char(MaskFileMat,'MidOcc_r.img');   
MaskFileMat=char(MaskFileMat,'InfOcc_l.img');         
MaskFileMat=char(MaskFileMat,'InfOcc_r.img');    
MaskFileMat=char(MaskFileMat,'Cuneus_l.img');         
MaskFileMat=char(MaskFileMat,'Cuneus_r.img');  
MaskFileMat=char(MaskFileMat,'Calcarine_l.img');      
MaskFileMat=char(MaskFileMat,'Calcarine_r.img');  
MaskFileMat=char(MaskFileMat,'Lingual_l.img');
MaskFileMat=char(MaskFileMat,'Lingual_r.img');
MaskFileMat=char(MaskFileMat,'Fusiform_l.img');       
MaskFileMat=char(MaskFileMat,'Fusiform_r.img'); 
MaskFileMat=char(MaskFileMat,'SupTempPole_l.img');    
MaskFileMat=char(MaskFileMat,'SupTempPole_r.img'); 
MaskFileMat=char(MaskFileMat,'MidTempPole_l.img');    
MaskFileMat=char(MaskFileMat,'MidTempPole_r.img'); 
MaskFileMat=char(MaskFileMat,'AntCing_l.img');        
MaskFileMat=char(MaskFileMat,'AntCing_r.img'); 
MaskFileMat=char(MaskFileMat,'MedCing_l.img');        
MaskFileMat=char(MaskFileMat,'MedCing_r.img');
MaskFileMat=char(MaskFileMat,'PostCing_l.img');       
MaskFileMat=char(MaskFileMat,'PostCing_r.img'); 
MaskFileMat=char(MaskFileMat,'HippPara_l.img');       
MaskFileMat=char(MaskFileMat,'HippPara_r.img'); 
MaskFileMat=char(MaskFileMat,'Insula_l.img');         
MaskFileMat=char(MaskFileMat,'Insula_r.img'); 
MaskFileMat=char(MaskFileMat,'Amy_l.img');            
MaskFileMat=char(MaskFileMat,'Amy_r.img');            
MaskFileMat=char(MaskFileMat,'BasGang_l.img');        
MaskFileMat=char(MaskFileMat,'BasGang_r.img');        
MaskFileMat=char(MaskFileMat,'Tha_l.img');            
MaskFileMat=char(MaskFileMat,'Tha_r.img');      
MaskFileMat=char(MaskFileMat,'CerebVermis.img');      
MaskFileMat=char(MaskFileMat,'Cereb_l.img');          
MaskFileMat=char(MaskFileMat,'Cereb_r.img'); 

NMask=size(MaskFileMat,1);
%=================================================================

if isempty(ConEnd)
    ConEnd=size(F.names,2);
end
NCon=ConEnd-ConStart+1;
MaskMat=-1.*ones(NSub,NMask,15);
MaskMat(:,:,2)=zeros(NSub,NMask,1);
MaskMat(:,:,6:15)=zeros(NSub,NMask,10);

hTmpFig=figure('Name',SubgroupDir,'Color',[1 1 1], 'NumberTitle','off');

for SubInd=1:NSub
    ActSub=SubVec(SubInd);
    ActSubStr=int2str(ActSub);
    if ActSub<10
        ActSubStr=['0',ActSubStr];
    end
    BasePath=['D:\ValAro\',ActSubStr,'\snraS',ActSubStr,'Base',BaseStr,'Smooth',SmoothStr,'\'];
    for i=ConStart:ConEnd
        Con=i+1;
        BATCHMJ.Ic=Con
        FullConDir=BasePath
        BATCHMJ.SWD=FullConDir;
        %========================================================
        [hReg,SPM,VOL,xX,xCon,xSDM]=spm_results_ui;
        spm_list('List',BATCHMJSPM,BATCHMJVOL,[],[],'',hReg);
        
        for MaskInd=1:NMask
            MaskFile=deblank(MaskFileMat(MaskInd,:));
            BATCHMJ.MaskImage=[MaskPath,MaskFile];
            spm_VOI(BATCHMJSPM,BATCHMJVOL);
            TabDat=BATCHMJ.TabDat;
            TabDatDat=TabDat.dat;
            NCluster=size(TabDatDat,1)
            NCluster=1
            NSigCluster=0;
            NSigCluster=1;
            ClusterSigVec=[];
            SigCluster=[];
            Clusterxyz=zeros(NCluster,3);
%             for i=1:NCluster
%                 if ~isempty(TabDatDat{i,3})
%                     NSigCluster=NSigCluster+1;
%                     ClusterSigVec(NSigCluster)=TabDatDat{i,3};
%                     ClusterNVoxVec(NSigCluster)=TabDatDat{i,4};
%                     Clusterxyz(NSigCluster,:)=TabDatDat{i,10}';
%                 end
%             end
%             if ~isempty(ClusterSigVec)
%                 SigCluster=find(ClusterSigVec<=0.05);
%             end
%             if ~isempty(SigCluster)
            if ~isempty(TabDatDat)
                SetSig=TabDatDat{1,1}
%                 [Sig,SigInd]=min(ClusterSigVec(SigCluster))
                SigInd=1
%                 NSigVox=sum(ClusterNVoxVec(SigCluster))
%                 Sigxyz=Clusterxyz(SigInd,:)
                Clusterxyz(NSigCluster,:)=TabDatDat{1,10}'
                %                 MaskMat(Con-1,MaskInd,1)=Sig;
                %                 MaskMat(Con-1,MaskInd,2)=NSigVox;
                %                 MaskMat(Con-1,MaskInd,3)=Sigxyz(1);
                %                 MaskMat(Con-1,MaskInd,4)=Sigxyz(2);
                %                 MaskMat(Con-1,MaskInd,5)=Sigxyz(3);
%                 MaskMat(SubInd,MaskInd,1)=Sig;
%                 MaskMat(SubInd,MaskInd,2)=NSigVox;
%                 MaskMat(SubInd,MaskInd,3)=Sigxyz(1);
%                 MaskMat(SubInd,MaskInd,4)=Sigxyz(2);
%                 MaskMat(SubInd,MaskInd,5)=Sigxyz(3);
                h=get(0,'CurrentFigure');
                h = spm_mip_ui('FindMIPax',h);
                %[xyz,d] = spm_mip_ui('Jump',h,'glmax');
                [xyz,d] = spm_mip_ui('SetCoords',Clusterxyz(SigInd,:),h);
                BATCHMJ.ss=1           %1 == 09 Slow;  2 == 36 Fast
                spm_graph(SPM,VOL,xX,xCon,xSDM,hReg)
                for i=1:5
                    MaskMat(SubInd,MaskInd,5+i)=GraphMJ(i).Y(63);
                end
                Slow=squeeze(MaskMat(SubInd,MaskInd,6:10));
                Slow=Slow-mean(Slow);
                pause(.1)
                BATCHMJ.ss=2           %1 == 09 Slow;  2 == 36 Fast
                spm_graph(SPM,VOL,xX,xCon,xSDM,hReg)
                for i=1:5
                    MaskMat(SubInd,MaskInd,10+i)=GraphMJ(i).Y(63);
                end
                Fast=squeeze(MaskMat(SubInd,MaskInd,11:15));
                Fast=Fast-mean(Fast);
                figure(hTmpFig)
                set(hTmpFig,'Name',[SubgroupDir,' - ',MaskFile])
                if strcmp(SubgroupDir,'Male')
                    axes('Position',[(MaskInd-1)./NMask (SubInd-1)./(NSub+1) 1/NMask 1/(NSub+1)])
                else
                    axes('Position',[(MaskInd-1)./NMask (SubInd-1)./NSub 1/NMask 1/NSub])
                end
                plot(Slow,'b')
                hold on
                plot(Fast,'r')
                if ~isempty(findstr(MaskFile,'_r.'))
                    plot(zeros(5,1),'k--')
                else
                    plot(zeros(5,1),'g--')
                end
                hold off
                axis([0 6 -1.5 1.5])
                axis off
                pause(.1)
            end
            pause(.1)
        end  
    end
end
%============================================================
fid1=fopen(['D:\ValAro',filesep,'SigP_u',uuStr,'k',kStr,'.txt'],'w','b');
fid2=fopen(['D:\ValAro',filesep,'NSigVox_u',uuStr,'k',kStr,'.txt'],'w','b');
fid3=fopen(['D:\ValAro',filesep,'SigVoxCart_u',uuStr,'k',kStr,'.txt'],'w','b');
fid4=fopen(['D:\ValAro',filesep,'Amp63Slow_u',uuStr,'k',kStr,'.txt'],'w','b');
fid5=fopen(['D:\ValAro',filesep,'Amp63Fast_u',uuStr,'k',kStr,'.txt'],'w','b');
fprintf(fid1,['Row\t']);
fprintf(fid2,['Row\t']);
fprintf(fid3,['Row\t']);
fprintf(fid4,['Row\t']);
fprintf(fid5,['Row\t']);
for MaskInd=1:NMask
    Str=deblank(MaskFileMat(MaskInd,:));
    Str=Str(1:end-4);
    fprintf(fid1,Str);
    fprintf(fid2,Str);
    fprintf(fid3,Str);
    fprintf(fid4,Str);
    fprintf(fid5,Str);
    if MaskInd<NMask
        fprintf(fid1,'\t');
        fprintf(fid2,'\t');
        fprintf(fid3,'\t');
        fprintf(fid4,'\t');
        fprintf(fid5,'\t');
    end
end
fprintf(fid1,'\n');
fprintf(fid2,'\n');
fprintf(fid3,'\n');
fprintf(fid4,'\n');
fprintf(fid5,'\n');
for SubInd=1:NSub
    fprintf(fid1,'%g\t',SubInd);
    fprintf(fid2,'%g\t',SubInd);
    fprintf(fid3,'%g\t',SubInd);
    fprintf(fid4,'%g\t',SubInd);
    fprintf(fid5,'%g\t',SubInd);
    for MaskInd=1:NMask
        if MaskMat(SubInd,MaskInd,1)<0
            fprintf(fid1,' > 0.05');
        elseif MaskMat(SubInd,MaskInd,1)<0.0001
            fprintf(fid1,'0.0001');
        else
            fprintf(fid1,'%1.4f',MaskMat(SubInd,MaskInd,1));
        end
        fprintf(fid2,'%g',MaskMat(SubInd,MaskInd,2));
        if MaskMat(SubInd,MaskInd,2)>0
            fprintf(fid3,'%g %g %g',MaskMat(SubInd,MaskInd,3:5));
            fprintf(fid4,'%g %g %g %g %g',MaskMat(SubInd,MaskInd,6:10));
            fprintf(fid5,'%g %g %g %g %g',MaskMat(SubInd,MaskInd,11:15));
        else
            fprintf(fid3,'p > 0.05');
            fprintf(fid4,'p > 0.05');
            fprintf(fid5,'p > 0.05');
        end
        if MaskInd<NMask
            fprintf(fid1,'\t');
            fprintf(fid2,'\t');
            fprintf(fid3,'\t');
            fprintf(fid4,'\t');
            fprintf(fid5,'\t');
        end
    end
    if SubInd<NSub
        fprintf(fid1,'\n');
        fprintf(fid2,'\n');
        fprintf(fid3,'\n');
        fprintf(fid4,'\n');
        fprintf(fid5,'\n');
    end
end
fclose(fid1);
fclose(fid2);
fclose(fid3);
fclose(fid4);
fclose(fid5);
