function []=BatchResults(ConStart,ConEnd,SubVec,SubgroupDir,uu,k)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if nargin<1; ConStart=[]; end
if nargin<2; ConEnd=[]; end
if nargin<3; SubVec=[]; end
if nargin<4; SubgroupDir=[]; end
if nargin<5; uu=[]; end
if nargin<6; k=[]; end

global BATCHMJ BATCHMJSPM BATCHMJVOL hReg PRINTSTR MaskMat

%Changes in (search for BATCHMJ):
%spm_spm_ui
%spm_result_ui
%spm_getSPM
%spm_conman
%spm_render

if isempty(ConStart); ConStart=1; end %Starts with Con+1
if isempty(ConEnd);   ConEnd=[1];  end %Ends with Con+1; if isempty(ConEnd); ConEnd=size(F.names,2); end
if isempty(SubgroupDir); SubgroupDir='All'; end
if isempty(uu); uu=0.05; end
if isempty(k);  k=10; end

PrintFullGlassStatsStatus=0;
WriteFilteredStatus=1;
CalcVoiStatus=0;

ucStr='u' % 'u'=>uncorrected; 'c'=>corrected
uuStr=uu.*1000;
if uuStr<10
    uuStr=['00',num2str(uuStr)] 
elseif uuStr<100
    uuStr=['0',num2str(uuStr)]
else
    uuStr=num2str(uuStr)
end
kStr=int2str(k);

BATCHMJ.ucStr=ucStr
BATCHMJ.uu=uu;
BATCHMJ.k=k
BATCHMJ.Ic=2
BATCHMJ.SPACE='I'
BATCHMJ.TabDat=[]
BATCHMJ.Cp=3    %'Event/epoch-related responses'
BATCHMJ.rep=1
BATCHMJ.tr=1:5
BATCHMJ.Cr=1    %fitted response
BATCHMJ.jsc='stay'
BATCHMJ.ssstart=2      %1 == 09 Slow;  2 == 36 Fast
BATCHMJ.ssstep=2

BaseStr='0';
SmoothStr='08';

FlipStatus=0;
if isempty(SubVec)   
    FemaleVec=[7 9 10 11 13 14 16 17 18 20 22]
    MaleVec  =[3 4  5  6  12 15 21 23 24 25] % 2
    if strcmp(SubgroupDir,'All') | strcmp(SubgroupDir,'Gender')
        SubVec=[MaleVec,FemaleVec]
    elseif strcmp(SubgroupDir,'Female')
        SubVec=FemaleVec
    elseif strcmp(SubgroupDir,'Male')
        SubVec=MaleVec
    end
end
NSub=length(SubVec);

%GrandParentDir=['D:\ValAro\00_Stats_NoScaling\RandStatsSmooth',SmoothStr];
GrandParentDir=['D:\ValAro\00ScalingVsNoScaling']
%GrandParentDir=['D:\ValAro\00_Stats_Scaling\RandStatsSmooth08']
%GrandParentDir=['D:\ValAro\00_Stats_NoScaling\RandStatsSmooth08']
RendFilePath='C:\Programme\Matlab12\toolbox\spm99\rend\render_smooth_average.mat';

%======================Create ParentDir==================
ParentDir=[GrandParentDir,filesep,SubgroupDir];
[MkDirStatus,MkDirMsg]=mkdir(GrandParentDir,SubgroupDir);
if MkDirStatus==1;
    fprintf(['Make directory: ',SubgroupDir,' !\n\n'])
elseif MkDirStatus==2;
    fprintf(['Directory: ',SubgroupDir,' already exists !\n\n'])
elseif MkDirStatus==0;
    MkDirStatus=MkDirStatus
    MkDirMsg=MkDirMsg
    pause;
end
%======================Create VoiDir==================
VoiDir='Voi'
FullVoiDir=[ParentDir,filesep,VoiDir]
[MkDirStatus,MkDirMsg]=mkdir(ParentDir,VoiDir);
if MkDirStatus==1;
    fprintf(['Make directory: ',VoiDir,' !\n\n'])
elseif MkDirStatus==2;
    fprintf(['Directory: ',VoiDir,' already exists !\n\n'])
elseif MkDirStatus==0;
    MkDirStatus=MkDirStatus
    MkDirMsg=MkDirMsg
    pause;
end
%======================Create ContrastDir==================
ContrastDir='XContrasts';
FullContrastDir=[ParentDir,filesep,ContrastDir];
[MkDirStatus,MkDirMsg]=mkdir(ParentDir,ContrastDir);
if MkDirStatus==1;
    fprintf(['Make directory: ',ContrastDir,' !\n\n'])
elseif MkDirStatus==2;
    fprintf(['Directory: ',ContrastDir,' already exists !\n\n'])
elseif MkDirStatus==0;
    MkDirStatus=MkDirStatus
    MkDirMsg=MkDirMsg
    pause;
end
%======================Create StatsDir==================
StatsDir=[ucStr,uuStr,'k',kStr]
FullStatsDir=[ParentDir,filesep,StatsDir]
[MkDirStatus,MkDirMsg]=mkdir(ParentDir,StatsDir);
if MkDirStatus==1;
    fprintf(['Make directory: ',StatsDir,' !\n\n'])
elseif MkDirStatus==2;
    fprintf(['Directory: ',StatsDir,' already exists !\n\n'])
elseif MkDirStatus==0;
    MkDirStatus=MkDirStatus
    MkDirMsg=MkDirMsg
    pause;
end
%======================Create FullGlassStatsDir==================
GlassStatsDir='GlassStatsJpg'
FullGlassStatsDir=[FullStatsDir,filesep,GlassStatsDir]
[MkDirStatus,MkDirMsg]=mkdir(FullStatsDir,GlassStatsDir);
if MkDirStatus==1;
    fprintf(['Make directory: ',GlassStatsDir,' !\n\n'])
elseif MkDirStatus==2;
    fprintf(['Directory: ',GlassStatsDir,' already exists !\n\n'])
elseif MkDirStatus==0;
    MkDirStatus=MkDirStatus
    MkDirMsg=MkDirMsg
    pause;
end
%======================Create FullGlassRenderDir==================
GlassRenderDir='GlassRenderJpg'
FullGlassRenderDir=[FullStatsDir,filesep,GlassRenderDir]
[MkDirStatus,MkDirMsg]=mkdir(FullStatsDir,GlassRenderDir);
if MkDirStatus==1;
    fprintf(['Make directory: ',GlassRenderDir,' !\n\n'])
elseif MkDirStatus==2;
    fprintf(['Directory: ',GlassRenderDir,' already exists !\n\n'])
elseif MkDirStatus==0;
    MkDirStatus=MkDirStatus
    MkDirMsg=MkDirMsg
    pause;
end
%======================Create FilteredDir==================
FilteredDir='Filtered'
FullFilteredDir=[FullStatsDir,filesep,FilteredDir]
[MkDirStatus,MkDirMsg]=mkdir(FullStatsDir,FilteredDir);
if MkDirStatus==1;
    fprintf(['Make directory: ',FilteredDir,' !\n\n'])
elseif MkDirStatus==2;
    fprintf(['Directory: ',FilteredDir,' already exists !\n\n'])
elseif MkDirStatus==0;
    MkDirStatus=MkDirStatus
    MkDirMsg=MkDirMsg
    pause;
end
%=================================================================
F = struct( ...
    'names',  {{...
            'CPosHiGTNeutAll','CPosHiLTNeutAll','CNegHiGTNeutAll','CNegHiLTNeutAll','CPosLoGTNeutAll',...
            'CPosLoLTNeutAll','CNegLoGTNeutAll','CNegLoLTNeutAll','CPosHiGTNegHiAll','CPosHiLTNegHiAll',...                 %10
            'CPosLoGTNegLoAll','CPosLoLTNegLoAll','CAroHiGTLoAll','CAroHiLTLoAll','CAroLinHiGTLoAll',...
            'CAroLinHiLTLoAll','CAroExp1HiGTLoAll','CAroExp1HiLTLoAll','CAroExp2HiGTLoAll','CAroExp2HiLTLoAll',...           %20
            'CValPosGTNegAll','CValPosLTNegAll','CPosHiGTNeutSlow','CPosHiLTNeutSlow','CNegHiGTNeutSlow',...
            'CNegHiLTNeutSlow','CPosLoGTNeutSlow','CPosLoLTNeutSlow','CNegLoGTNeutSlow','CNegLoLTNeutSlow',...               %30
            'CPosHiGTNegHiSlow','CPosHiLTNegHiSlow','CPosLoGTNegLoSlow','CPosLoLTNegLoSlow','CAroHiGTLoSlow',...
            'CAroHiLTLoSlow','CAroLinHiGTLoSlow','CAroLinHiLTLoSlow','CAroExp1HiGTLoSlow','CAroExp1HiLTLoSlow',...           %40
            'CAroExp2HiGTLoSlow','CAroExp2HiLTLoSlow','CValPosGTNegSlow','CValPosLTNegSlow','CPosHiGTNeutFast',...
            'CPosHiLTNeutFast','CNegHiGTNeutFast','CNegHiLTNeutFast','CPosLoGTNeutFast','CPosLoLTNeutFast',...               %50
            'CNegLoGTNeutFast','CNegLoLTNeutFast','CPosHiGTNegHiFast','CPosHiLTNegHiFast','CPosLoGTNegLoFast',...             
            'CPosLoLTNegLoFast','CAroHiGTLoFast','CAroHiLTLoFast','CAroLinHiGTLoFast','CAroLinHiLTLoFast',...                 %60
            'CAroExp1HiGTLoFast','CAroExp1HiLTLoFast','CAroExp2HiGTLoFast','CAroExp2HiLTLoFast','CValPosGTNegFast',...
            'CValPosLTNegFast','CFastGTSlow','CFastLTSlow','CFastGTSlowNegHi','CFastLTSlowNegHi',...                            %70
            'CFastGTSlowNegLo','CFastLTSlowNegLo','CFastGTSlowNeut','CFastLTSlowNeut','CFastGTSlowPosLo',...
            'CFastLTSlowPosLo','CFastGTSlowPosHi','CFastLTSlowPosHi','CFastGTSlowHiAro','CFastLTSlowHiAro',...                  %80
            'CFastGTSlowLoAro','CFastLTSlowLoAro','CFastGTSlowNegVal','CFastLTSlowNegVal','CFastGTSlowPosVal', ...
            'CFastLTSlowPosVal','CPosHiLTPosLoAll','CPosHiGTPosLoAll','CPosHiLTPosLoSlow','CPosHiGTPosLoSlow', ...              %90
            'CPosHiLTPosLoFast','CPosHiGTPosLoFast','CNegHiLTNegLoAll','CNegHiGTNegLoAll','CNegHiLTNegLoSlow', ...
            'CNegHiGTNegLoSlow','CNegHiLTNegLoFast','CNegHiGTNegLoFast','CPosHiLTNegLoAll','CPosHiGTNegLoAll', ...             %100
            'CPosHiLTNegLoSlow','CPosHiGTNegLoSlow','CPosHiLTNegLoFast','CPosHiGTNegLoFast','CNegHiLTPosLoAll', ...
            'CNegHiGTPosLoAll', 'CNegHiLTPosLoSlow','CNegHiGTPosLoSlow','CNegHiLTPosLoFast','CNegHiGTPosLoFast', ...            %110
            'CAroHiGTLoNoNeutralAll','CAroHiLTLoNoNeutralAll','CAroHiGTLoNoNeutralSlow','CAroHiLTLoNoNeutralSlow','CAroHiGTLoNoNeutralFast',...
            'CAroHiLTLoNoNeutralFast','CAroLoGTNeutralAll','CAroLoLTNeutralAll','CAroLoGTNeutralSlow','CAroLoLTNeutralSlow',... %120
            'CAroLoGTNeutralFast','CAroLoLTNeutralFast','CAroHiGTNeutralAll','CAroHiLTNeutralAll','CAroHiGTNeutralSlow',...
            'CAroHiLTNeutralSlow','CAroHiGTNeutralFast','CAroHiLTNeutralFast', ...
        }})

F = struct( ...
    'names',  {{...
            'ScaleGTNoScale','ScaleLTNoScale',...
              }})
%=================================================================
MaskPath='C:\Programme\Matlab12\toolbox\spm99\masken\';  

MaskFileMat=char('PreCentral_l.img');    
MaskFileMat=char(MaskFileMat,'Precentral_r.img'); 
MaskFileMat=char(MaskFileMat,'PostCentral_l.img');
MaskFileMat=char(MaskFileMat,'PostCentral_r.img');
MaskFileMat=char(MaskFileMat,'RolOper_l.img');    
MaskFileMat=char(MaskFileMat,'RolOper_r.img');
MaskFileMat=char(MaskFileMat,'SupFrontDorsLat_l.img');
MaskFileMat=char(MaskFileMat,'SupFrontDorsLat_r.img');
MaskFileMat=char(MaskFileMat,'MidFrontLat_l.img');    
MaskFileMat=char(MaskFileMat,'MidFrontLat_r.img'); 
MaskFileMat=char(MaskFileMat,'InfFrontOper_l.img');   
MaskFileMat=char(MaskFileMat,'InfFrontOper_r.img');    
MaskFileMat=char(MaskFileMat,'InfFrontTri_l.img');    
MaskFileMat=char(MaskFileMat,'InfFrontTri_r.img');
MaskFileMat=char(MaskFileMat,'SupFrontMed_l.img');    
MaskFileMat=char(MaskFileMat,'SupFrontMed_r.img'); 
MaskFileMat=char(MaskFileMat,'SMA_l.img');            
MaskFileMat=char(MaskFileMat,'SMA_r.img');  
MaskFileMat=char(MaskFileMat,'ParaCentral_l.img');    
MaskFileMat=char(MaskFileMat,'ParaCentral_r.img'); 
MaskFileMat=char(MaskFileMat,'SupFrontOrb_l.img');    
MaskFileMat=char(MaskFileMat,'SupFrontOrb_r.img'); 
MaskFileMat=char(MaskFileMat,'SupFrontMedOrb_l.img');    
MaskFileMat=char(MaskFileMat,'SupFrontMedOrb_r.img');
MaskFileMat=char(MaskFileMat,'MidFrontOrb_l.img');    
MaskFileMat=char(MaskFileMat,'MidFrontOrb_r.img');  
MaskFileMat=char(MaskFileMat,'InfFrontOrb_l.img');
MaskFileMat=char(MaskFileMat,'InfFrontOrb_r.img');
MaskFileMat=char(MaskFileMat,'RectOrb_l.img');        
MaskFileMat=char(MaskFileMat,'RectOrb_r.img'); 
MaskFileMat=char(MaskFileMat,'Olfac_l.img');          
MaskFileMat=char(MaskFileMat,'Olfac_r.img');   
MaskFileMat=char(MaskFileMat,'SupTemp_l.img');        
MaskFileMat=char(MaskFileMat,'SupTemp_r.img'); 
MaskFileMat=char(MaskFileMat,'Heschl_l.img');         
MaskFileMat=char(MaskFileMat,'Heschl_r.img');  
MaskFileMat=char(MaskFileMat,'MidTemp_l.img');        
MaskFileMat=char(MaskFileMat,'MidTemp_r.img');   
MaskFileMat=char(MaskFileMat,'InfTemp_l.img');        
MaskFileMat=char(MaskFileMat,'InfTemp_r.img'); 
MaskFileMat=char(MaskFileMat,'SupPar_l.img');         
MaskFileMat=char(MaskFileMat,'SupPar_r.img'); 
MaskFileMat=char(MaskFileMat,'InfPar_l.img');         
MaskFileMat=char(MaskFileMat,'InfPar_r.img');  
MaskFileMat=char(MaskFileMat,'Angular_l.img');        
MaskFileMat=char(MaskFileMat,'Angular_r.img');  
MaskFileMat=char(MaskFileMat,'SupraMarg_l.img');      
MaskFileMat=char(MaskFileMat,'SupraMarg_r.img');
MaskFileMat=char(MaskFileMat,'Precuneus_l.img');      
MaskFileMat=char(MaskFileMat,'Precuneus_r.img');  
MaskFileMat=char(MaskFileMat,'SupOcc_l.img');         
MaskFileMat=char(MaskFileMat,'SupOcc_r.img');  
MaskFileMat=char(MaskFileMat,'MidOcc_l.img');         
MaskFileMat=char(MaskFileMat,'MidOcc_r.img');   
MaskFileMat=char(MaskFileMat,'InfOcc_l.img');         
MaskFileMat=char(MaskFileMat,'InfOcc_r.img');    
MaskFileMat=char(MaskFileMat,'Cuneus_l.img');         
MaskFileMat=char(MaskFileMat,'Cuneus_r.img');  
MaskFileMat=char(MaskFileMat,'Calcarine_l.img');      
MaskFileMat=char(MaskFileMat,'Calcarine_r.img');  
MaskFileMat=char(MaskFileMat,'Lingual_l.img');
MaskFileMat=char(MaskFileMat,'Lingual_r.img');
MaskFileMat=char(MaskFileMat,'Fusiform_l.img');       
MaskFileMat=char(MaskFileMat,'Fusiform_r.img'); 
MaskFileMat=char(MaskFileMat,'SupTempPole_l.img');    
MaskFileMat=char(MaskFileMat,'SupTempPole_r.img'); 
MaskFileMat=char(MaskFileMat,'MidTempPole_l.img');    
MaskFileMat=char(MaskFileMat,'MidTempPole_r.img'); 
MaskFileMat=char(MaskFileMat,'AntCing_l.img');        
MaskFileMat=char(MaskFileMat,'AntCing_r.img'); 
MaskFileMat=char(MaskFileMat,'MedCing_l.img');        
MaskFileMat=char(MaskFileMat,'MedCing_r.img');
MaskFileMat=char(MaskFileMat,'PostCing_l.img');       
MaskFileMat=char(MaskFileMat,'PostCing_r.img'); 
MaskFileMat=char(MaskFileMat,'HippPara_l.img');       
MaskFileMat=char(MaskFileMat,'HippPara_r.img'); 
MaskFileMat=char(MaskFileMat,'Insula_l.img');         
MaskFileMat=char(MaskFileMat,'Insula_r.img'); 
MaskFileMat=char(MaskFileMat,'Amy_l.img');            
MaskFileMat=char(MaskFileMat,'Amy_r.img');            
MaskFileMat=char(MaskFileMat,'BasGang_l.img');        
MaskFileMat=char(MaskFileMat,'BasGang_r.img');        
MaskFileMat=char(MaskFileMat,'Tha_l.img');            
MaskFileMat=char(MaskFileMat,'Tha_r.img');      
MaskFileMat=char(MaskFileMat,'CerebVermis.img');      
MaskFileMat=char(MaskFileMat,'Cereb_l.img');          
MaskFileMat=char(MaskFileMat,'Cereb_r.img'); 

NMask=size(MaskFileMat,1);
%=================================================================

if isempty(ConEnd)
    ConEnd=size(F.names,2);
end
NCon=ConEnd-ConStart+1;
MaskMat=-1.*ones(NCon,NMask,5);
MaskMat(:,:,2)=zeros(NCon,NMask,1);
for i=ConStart:ConEnd
    Con=i+1;
    if Con<10
        PreConStr=['00',int2str(Con)];
    elseif Con>9 & Con<100
        PreConStr=['0',int2str(Con)];
    else
        PreConStr=[int2str(Con)];
    end
    if Con==1
        ConStr='EffectsOfInterest'
        ConDir=[PreConStr,'_EffectsOfInterest'];
        File=['ess_0',PreConStr,'.img'];
    else
        ConStr=char(F.names(Con-1));
        ConName=[PreConStr,'_',ConStr];
        ConDir=[PreConStr,'_',ConStr(2:length(ConStr))]
        File=['con_0',PreConStr,'.img'];
    end
    FullConDir=[FullContrastDir,filesep,ConDir]; 
    BATCHMJ.SWD=FullConDir;
    %========================================================
    hReg=spm_results_ui; %vargout(1){hReg,SPM,VOL,xX,xCon,xSDM};
    spm_list('List',BATCHMJSPM,BATCHMJVOL,[],[],'',hReg);
    if PrintFullGlassStatsStatus
        eval(['cd ',FullGlassStatsDir])
        PRINTSTR=['print -djpeg100 -painters -append -noui ',ConDir,'.jpg']
        spm_figure('Print')
        pause(2)
    end
    if WriteFilteredStatus
        FilterPath=[FullFilteredDir,filesep,ConDir];
        [MkDirStatus,MkDirMsg]=mkdir(FullFilteredDir,ConDir);
        if MkDirStatus==1;
            fprintf(['Make directory: ',ConDir,' !\n\n'])
        elseif MkDirStatus==2;
            fprintf(['Directory: ',ConDir,' already exists !\n\n'])
        elseif MkDirStatus==0;
            MkDirStatus=MkDirStatus
            MkDirMsg=MkDirMsg
            pause;
        end
        eval(['cd ',FilterPath])
        spm_write_filtered(BATCHMJSPM.Z,BATCHMJSPM.XYZ,BATCHMJVOL.DIM,BATCHMJVOL.M,...
            sprintf('SPM{%c}-filtered: u = %5.3f, k = %d',BATCHMJSPM.STAT,BATCHMJSPM.u,BATCHMJSPM.k),ConDir);
        FilterFilePathImg=[FilterPath,filesep,ConDir,'.img'];
        [TValVec,BMat,MMat,MniMat,ValFilePath,BTalFilePath,MTalFilePath,MniFilePath]=Vox2Tal(FilterFilePathImg);
        TDStrFilePath=['H:\TD\TDStrSort.txt'];
        TDCoorFilePath=['H:\TD\TDCoorSort.txt'];
        [BTalFile,BTalPath]=SepFilePath(BTalFilePath)
        TdFilePath=[BTalPath,'TD_',BTalFile];
        FindTD([],BTalFilePath,TDStrFilePath,TDCoorFilePath,TdFilePath)
        CalcTalStat(20,TdFilePath,ValFilePath);
        CalcTalStatBA(20,TdFilePath,ValFilePath);
        if ~isempty(TValVec)
            spm_render(struct('XYZ',BATCHMJSPM.XYZ,'t',BATCHMJSPM.Z,'mat',BATCHMJVOL.M,'dim',BATCHMJVOL.DIM),NaN,RendFilePath);
        end
        eval(['cd ',FullGlassRenderDir])
        PRINTSTR=['print -djpeg100 -painters -append -noui ',ConDir,'.jpg']
        spm_figure('Print')
    end
    pause(2)
    if CalcVoiStatus==1;
        for MaskInd=1:NMask
            BATCHMJ.MaskImage=[MaskPath,deblank(MaskFileMat(MaskInd,:))];
            spm_VOI(BATCHMJSPM,BATCHMJVOL);
            TabDat=BATCHMJ.TabDat;
            TabDatDat=TabDat.dat;
            NCluster=size(TabDatDat,1);
            NSigCluster=0;
            ClusterSigVec=[];
            SigCluster=[];
            Clusterxyz=zeros(NCluster,3);
            for i=1:NCluster
                if ~isempty(TabDatDat{i,3})
                    NSigCluster=NSigCluster+1;
                    ClusterSigVec(NSigCluster)=TabDatDat{i,3};
                    ClusterNVoxVec(NSigCluster)=TabDatDat{i,4};
                    Clusterxyz(NSigCluster,:)=TabDatDat{i,10}';
                end
            end
            if ~isempty(ClusterSigVec)
                SigCluster=find(ClusterSigVec<=0.05);
            end
            if ~isempty(SigCluster)
                [Sig,SigInd]=min(ClusterSigVec(SigCluster))
                NSigVox=sum(ClusterNVoxVec(SigCluster))
                Sigxyz=Clusterxyz(SigInd,:)
                MaskMat(Con-1,MaskInd,1)=Sig;
                MaskMat(Con-1,MaskInd,2)=NSigVox;
                MaskMat(Con-1,MaskInd,3)=Sigxyz(1);
                MaskMat(Con-1,MaskInd,4)=Sigxyz(2);
                MaskMat(Con-1,MaskInd,5)=Sigxyz(3);
            end
            pause(.1)
        end  
    end
end


%============================================================
[FullVoiDir,filesep,SubgroupDir,'SigP_u',uuStr,'k',kStr,'.txt']
[FullVoiDir,filesep,SubgroupDir,'NSigVox_u',uuStr,'k',kStr,'.txt']
[FullVoiDir,filesep,SubgroupDir,'SigVoxCart_u',uuStr,'k',kStr,'.txt']
fid1=fopen([FullVoiDir,filesep,SubgroupDir,'SigP_u',uuStr,'k',kStr,'.txt'],'w','b');
fid2=fopen([FullVoiDir,filesep,SubgroupDir,'NSigVox_u',uuStr,'k',kStr,'.txt'],'w','b');
fid3=fopen([FullVoiDir,filesep,SubgroupDir,'SigVoxCart_u',uuStr,'k',kStr,'.txt'],'w','b');
fprintf(fid1,['Row\t Contrast\t']);
fprintf(fid2,['Row\t Contrast\t']);
fprintf(fid3,['Row\t Contrast\t']);
for MaskInd=1:NMask
    Str=deblank(MaskFileMat(MaskInd,:));
    Str=Str(1:end-4);
    fprintf(fid1,Str);
    fprintf(fid2,Str);
    fprintf(fid3,Str);
    if MaskInd<NMask
        fprintf(fid1,'\t');
        fprintf(fid2,'\t');
        fprintf(fid3,'\t');
    end
end
fprintf(fid1,'\n');
fprintf(fid2,'\n');
fprintf(fid3,'\n');
for ConInd=ConStart:ConEnd
    fprintf(fid1,'%g\t',ConInd);
    fprintf(fid2,'%g\t',ConInd);
    fprintf(fid3,'%g\t',ConInd);
    fprintf(fid1,[char(F.names(ConInd)),'\t']);
    fprintf(fid2,[char(F.names(ConInd)),'\t']);
    fprintf(fid3,[char(F.names(ConInd)),'\t']);
    for MaskInd=1:NMask
        fprintf(fid2,'%g',MaskMat(ConInd,MaskInd,2));
        if MaskMat(ConInd,MaskInd,2)==0
            fprintf(fid1,'');
            fprintf(fid3,'');
        else
            if MaskMat(ConInd,MaskInd,1)<0
                fprintf(fid1,'p > 0.05');
            elseif MaskMat(ConInd,MaskInd,1)<0.0001
                fprintf(fid1,' < 0.0001');
            else
                fprintf(fid1,'%1.4f',MaskMat(ConInd,MaskInd,1));
            end 
            fprintf(fid3,'%g %g %g',MaskMat(ConInd,MaskInd,3:5));            
        end
        if MaskInd<NMask
            fprintf(fid1,'\t');
            fprintf(fid2,'\t');
            fprintf(fid3,'\t');
        end
        
    end
    if ConInd<NCon
        fprintf(fid1,'\n');
        fprintf(fid2,'\n');
        fprintf(fid3,'\n');
    end
end
fclose(fid1);
fclose(fid2);
fclose(fid3);
return;